/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriversList;

public class JacobiansMapper {
    public static final int STATE_DIMENSION = 6;
    private String name;
    private final ParameterDriversList parameters;
    private final OrbitType orbitType;
    private final PositionAngle angleType;

    JacobiansMapper(String name, ParameterDriversList parameters, OrbitType orbitType, PositionAngle angleType) {
        this.name = name;
        this.parameters = parameters;
        this.orbitType = orbitType;
        this.angleType = angleType;
    }

    public String getName() {
        return this.name;
    }

    public int getAdditionalStateDimension() {
        return 6 * (6 + this.parameters.getNbParams());
    }

    @Deprecated
    public int getStateDimension() {
        return 6;
    }

    public int getParameters() {
        return this.parameters.getNbParams();
    }

    private double[][] getdYdC(SpacecraftState state) {
        double[][] dYdC = new double[6][6];
        Orbit orbit = this.orbitType.convertType(state.getOrbit());
        orbit.getJacobianWrtCartesian(this.angleType, dYdC);
        return dYdC;
    }

    void setInitialJacobians(SpacecraftState state, double[][] dY1dY0, double[][] dY1dP, double[] p) {
        Array2DRowRealMatrix dY1dC1 = new Array2DRowRealMatrix(this.getdYdC(state), false);
        DecompositionSolver solver = new QRDecomposition((RealMatrix)dY1dC1).getSolver();
        RealMatrix dC1dY0 = solver.solve((RealMatrix)new Array2DRowRealMatrix(dY1dY0, false));
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                p[index++] = dC1dY0.getEntry(i, j);
            }
        }
        if (this.parameters.getNbParams() != 0) {
            RealMatrix dC1dP = solver.solve((RealMatrix)new Array2DRowRealMatrix(dY1dP, false));
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < this.parameters.getNbParams(); ++j) {
                    p[index++] = dC1dP.getEntry(i, j);
                }
            }
        }
    }

    public void getStateJacobian(SpacecraftState state, double[][] dYdY0) {
        double[][] dYdC = this.getdYdC(state);
        double[] p = state.getAdditionalState(this.name);
        for (int i = 0; i < 6; ++i) {
            double[] rowC = dYdC[i];
            double[] rowD = dYdY0[i];
            for (int j = 0; j < 6; ++j) {
                double sum = 0.0;
                int pIndex = j;
                for (int k = 0; k < 6; ++k) {
                    sum += rowC[k] * p[pIndex];
                    pIndex += 6;
                }
                rowD[j] = sum;
            }
        }
    }

    public void getParametersJacobian(SpacecraftState state, double[][] dYdP) {
        if (this.parameters.getNbParams() != 0) {
            double[][] dYdC = this.getdYdC(state);
            double[] p = state.getAdditionalState(this.name);
            for (int i = 0; i < 6; ++i) {
                double[] rowC = dYdC[i];
                double[] rowD = dYdP[i];
                for (int j = 0; j < this.parameters.getNbParams(); ++j) {
                    double sum = 0.0;
                    int pIndex = j + 36;
                    for (int k = 0; k < 6; ++k) {
                        sum += rowC[k] * p[pIndex];
                        pIndex += this.parameters.getNbParams();
                    }
                    rowD[j] = sum;
                }
            }
        }
    }
}

