/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.PVCoordinatesProvider;

public class EclipseDetector
extends AbstractDetector<EclipseDetector> {
    private static final long serialVersionUID = 20131118L;
    private final PVCoordinatesProvider occulting;
    private final double occultingRadius;
    private final PVCoordinatesProvider occulted;
    private final double occultedRadius;
    private final boolean totalEclipse;

    public EclipseDetector(PVCoordinatesProvider occulted, double occultedRadius, PVCoordinatesProvider occulting, double occultingRadius) {
        this(600.0, 1.0E-6, occulted, occultedRadius, occulting, occultingRadius);
    }

    public EclipseDetector(double maxCheck, PVCoordinatesProvider occulted, double occultedRadius, PVCoordinatesProvider occulting, double occultingRadius) {
        this(maxCheck, 1.0E-6, occulted, occultedRadius, occulting, occultingRadius);
    }

    public EclipseDetector(double maxCheck, double threshold, PVCoordinatesProvider occulted, double occultedRadius, PVCoordinatesProvider occulting, double occultingRadius) {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), occulted, occultedRadius, occulting, occultingRadius, true);
    }

    private EclipseDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super EclipseDetector> handler, PVCoordinatesProvider occulted, double occultedRadius, PVCoordinatesProvider occulting, double occultingRadius, boolean totalEclipse) {
        super(maxCheck, threshold, maxIter, handler);
        this.occulted = occulted;
        this.occultedRadius = FastMath.abs((double)occultedRadius);
        this.occulting = occulting;
        this.occultingRadius = FastMath.abs((double)occultingRadius);
        this.totalEclipse = totalEclipse;
    }

    @Override
    protected EclipseDetector create(double newMaxCheck, double newThreshold, int nawMaxIter, EventHandler<? super EclipseDetector> newHandler) {
        return new EclipseDetector(newMaxCheck, newThreshold, nawMaxIter, newHandler, this.occulted, this.occultedRadius, this.occulting, this.occultingRadius, this.totalEclipse);
    }

    public EclipseDetector withUmbra() {
        return new EclipseDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.occulted, this.occultedRadius, this.occulting, this.occultingRadius, true);
    }

    public EclipseDetector withPenumbra() {
        return new EclipseDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.occulted, this.occultedRadius, this.occulting, this.occultingRadius, false);
    }

    public PVCoordinatesProvider getOcculting() {
        return this.occulting;
    }

    public double getOccultingRadius() {
        return this.occultingRadius;
    }

    public PVCoordinatesProvider getOcculted() {
        return this.occulted;
    }

    public double getOccultedRadius() {
        return this.occultedRadius;
    }

    public boolean getTotalEclipse() {
        return this.totalEclipse;
    }

    @Override
    public double g(SpacecraftState s) {
        Vector3D pted = this.occulted.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        Vector3D ping = this.occulting.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        Vector3D psat = s.getPVCoordinates().getPosition();
        Vector3D ps = pted.subtract((Vector)psat);
        Vector3D po = ping.subtract((Vector)psat);
        double angle = Vector3D.angle((Vector3D)ps, (Vector3D)po);
        double rs = FastMath.asin((double)(this.occultedRadius / ps.getNorm()));
        if (Double.isNaN(rs)) {
            return Math.PI;
        }
        double ro = FastMath.asin((double)(this.occultingRadius / po.getNorm()));
        if (Double.isNaN(ro)) {
            return -Math.PI;
        }
        return this.totalEclipse ? angle - ro + rs : angle - ro - rs;
    }
}

