/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.orbits.FieldCircularOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldEcksteinHechlerPropagator<T extends RealFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T> {
    private final FDSFactory<T> factory;
    private FieldEHModel<T> initialModel;
    private transient FieldTimeSpanMap<FieldEHModel<T>, T> models;
    private double referenceRadius;
    private double mu;
    private double[] ck0;

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, DEFAULT_LAW, (RealFieldElement)((RealFieldElement)initialOrbit.getA().getField().getZero()).add(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitude, T mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics) {
        this(initialOrbit, attitude, mass, provider.getAe(), provider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), harmonics.getUnnormalizedCnm(6, 0));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double c60) {
        this(initialOrbit, DEFAULT_LAW, (RealFieldElement)((RealFieldElement)initialOrbit.getDate().getField().getZero()).add(1000.0), referenceRadius, mu, c20, c30, c40, c50, c60);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, T mass, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, DEFAULT_LAW, mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, T mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double c60) {
        this(initialOrbit, DEFAULT_LAW, mass, referenceRadius, mu, c20, c30, c40, c50, c60);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, attitudeProv, (RealFieldElement)((RealFieldElement)initialOrbit.getA().getField().getZero()).add(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double c60) {
        this(initialOrbit, attitudeProv, (RealFieldElement)((RealFieldElement)initialOrbit.getDate().getField().getZero()).add(1000.0), referenceRadius, mu, c20, c30, c40, c50, c60);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double c60) {
        super(mass.getField(), attitudeProv);
        Field field = mass.getField();
        this.factory = new FDSFactory(field, 1, 2);
        try {
            this.referenceRadius = referenceRadius;
            this.mu = mu;
            this.ck0 = new double[]{0.0, 0.0, c20, c30, c40, c50, c60};
            this.resetInitialState(new FieldSpacecraftState<T>(initialOrbit, attitudeProv.getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass));
        }
        catch (OrekitException oe) {
            throw new OrekitException(oe);
        }
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        super.resetInitialState(state);
        this.initialModel = this.computeMeanParameters((FieldCircularOrbit)OrbitType.CIRCULAR.convertType(state.getOrbit()), state.getMass());
        this.models = new FieldTimeSpanMap(this.initialModel, state.getA().getField());
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        FieldEHModel<T> newModel = this.computeMeanParameters((FieldCircularOrbit)OrbitType.CIRCULAR.convertType(state.getOrbit()), state.getMass());
        if (forward) {
            this.models.addValidAfter(newModel, state.getDate());
        } else {
            this.models.addValidBefore(newModel, state.getDate());
        }
    }

    private FieldEHModel<T> computeMeanParameters(FieldCircularOrbit<T> osculating, T mass) {
        if (osculating.getA().getReal() < this.referenceRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, osculating.getA());
        }
        Field field = mass.getField();
        RealFieldElement one = (RealFieldElement)field.getOne();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        FieldEHModel<Object> current = new FieldEHModel(this.factory, osculating, mass, this.referenceRadius, this.mu, this.ck0);
        RealFieldElement epsilon = (RealFieldElement)one.multiply(1.0E-13);
        RealFieldElement thresholdA = (RealFieldElement)epsilon.multiply(((RealFieldElement)((FieldEHModel)current).mean.getA().abs()).add(1.0));
        RealFieldElement thresholdE = (RealFieldElement)epsilon.multiply(((FieldEHModel)current).mean.getE().add(1.0));
        RealFieldElement thresholdAngles = (RealFieldElement)epsilon.multiply(Math.PI);
        int i = 0;
        while (i++ < 100) {
            FieldDerivativeStructure<T>[] parameters = current.propagateParameters(((FieldEHModel)current).mean.getDate());
            RealFieldElement deltaA = (RealFieldElement)osculating.getA().subtract((Object)parameters[0].getValue());
            RealFieldElement deltaEx = (RealFieldElement)osculating.getCircularEx().subtract((Object)parameters[1].getValue());
            RealFieldElement deltaEy = (RealFieldElement)osculating.getCircularEy().subtract((Object)parameters[2].getValue());
            RealFieldElement deltaI = (RealFieldElement)osculating.getI().subtract((Object)parameters[3].getValue());
            RealFieldElement deltaRAAN = FieldEcksteinHechlerPropagator.normalizeAngle((RealFieldElement)osculating.getRightAscensionOfAscendingNode().subtract((Object)parameters[4].getValue()), zero);
            RealFieldElement deltaAlphaM = FieldEcksteinHechlerPropagator.normalizeAngle((RealFieldElement)osculating.getAlphaM().subtract((Object)parameters[5].getValue()), zero);
            current = new FieldEHModel<RealFieldElement>((FDSFactory<RealFieldElement>)this.factory, new FieldCircularOrbit<RealFieldElement>((RealFieldElement)((FieldEHModel)current).mean.getA().add((Object)deltaA), (RealFieldElement)((FieldEHModel)current).mean.getCircularEx().add((Object)deltaEx), (RealFieldElement)((FieldEHModel)current).mean.getCircularEy().add((Object)deltaEy), (RealFieldElement)((FieldEHModel)current).mean.getI().add((Object)deltaI), (RealFieldElement)((FieldEHModel)current).mean.getRightAscensionOfAscendingNode().add((Object)deltaRAAN), (RealFieldElement)((FieldEHModel)current).mean.getAlphaM().add((Object)deltaAlphaM), PositionAngle.MEAN, ((FieldEHModel)current).mean.getFrame(), ((FieldEHModel)current).mean.getDate(), this.mu), (RealFieldElement)mass, this.referenceRadius, this.mu, this.ck0);
            if (!(FastMath.abs((double)deltaA.getReal()) < thresholdA.getReal()) || !(FastMath.abs((double)deltaEx.getReal()) < thresholdE.getReal()) || !(FastMath.abs((double)deltaEy.getReal()) < thresholdE.getReal()) || !(FastMath.abs((double)deltaI.getReal()) < thresholdAngles.getReal()) || !(FastMath.abs((double)deltaRAAN.getReal()) < thresholdAngles.getReal()) || !(FastMath.abs((double)deltaAlphaM.getReal()) < thresholdAngles.getReal())) continue;
            return current;
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_ECKSTEIN_HECHLER_MEAN_PARAMETERS, i);
    }

    @Override
    public FieldCartesianOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date) {
        FieldEHModel<T> current = this.models.get(date);
        return new FieldCartesianOrbit<T>(this.toCartesian(date, current.propagateParameters(date)), ((FieldEHModel)current).mean.getFrame(), this.mu);
    }

    private TimeStampedFieldPVCoordinates<T> toCartesian(FieldAbsoluteDate<T> date, FieldDerivativeStructure<T>[] parameters) {
        FieldDerivativeStructure cosOmega = parameters[4].cos();
        FieldDerivativeStructure sinOmega = parameters[4].sin();
        FieldDerivativeStructure cosI = parameters[3].cos();
        FieldDerivativeStructure sinI = parameters[3].sin();
        FieldDerivativeStructure<T> alphaE = this.meanToEccentric(parameters[5], parameters[1], parameters[2]);
        FieldDerivativeStructure cosAE = alphaE.cos();
        FieldDerivativeStructure sinAE = alphaE.sin();
        FieldDerivativeStructure ex2 = parameters[1].multiply(parameters[1]);
        FieldDerivativeStructure ey2 = parameters[2].multiply(parameters[2]);
        FieldDerivativeStructure exy = parameters[1].multiply(parameters[2]);
        FieldDerivativeStructure q = ex2.add(ey2).subtract(1.0).negate().sqrt();
        FieldDerivativeStructure beta = q.add(1.0).reciprocal();
        FieldDerivativeStructure bx2 = beta.multiply(ex2);
        FieldDerivativeStructure by2 = beta.multiply(ey2);
        FieldDerivativeStructure bxy = beta.multiply(exy);
        FieldDerivativeStructure u = bxy.multiply(sinAE).subtract(parameters[1].add(by2.subtract(1.0).multiply(cosAE)));
        FieldDerivativeStructure v = bxy.multiply(cosAE).subtract(parameters[2].add(bx2.subtract(1.0).multiply(sinAE)));
        FieldDerivativeStructure x = parameters[0].multiply(u);
        FieldDerivativeStructure y = parameters[0].multiply(v);
        FieldVector3D p = new FieldVector3D((RealFieldElement)x.multiply(cosOmega).subtract(y.multiply(cosI.multiply(sinOmega))), (RealFieldElement)x.multiply(sinOmega).add(y.multiply(cosI.multiply(cosOmega))), (RealFieldElement)y.multiply(sinI));
        FieldVector3D p0 = new FieldVector3D(((FieldDerivativeStructure)p.getX()).getValue(), ((FieldDerivativeStructure)p.getY()).getValue(), ((FieldDerivativeStructure)p.getZ()).getValue());
        FieldVector3D p1 = new FieldVector3D(((FieldDerivativeStructure)p.getX()).getPartialDerivative(new int[]{1}), ((FieldDerivativeStructure)p.getY()).getPartialDerivative(new int[]{1}), ((FieldDerivativeStructure)p.getZ()).getPartialDerivative(new int[]{1}));
        FieldVector3D p2 = new FieldVector3D(((FieldDerivativeStructure)p.getX()).getPartialDerivative(new int[]{2}), ((FieldDerivativeStructure)p.getY()).getPartialDerivative(new int[]{2}), ((FieldDerivativeStructure)p.getZ()).getPartialDerivative(new int[]{2}));
        return new TimeStampedFieldPVCoordinates<T>(date, p0, p1, p2);
    }

    private FieldDerivativeStructure<T> meanToEccentric(FieldDerivativeStructure<T> alphaM, FieldDerivativeStructure<T> ex, FieldDerivativeStructure<T> ey) {
        FieldDerivativeStructure alphaE = alphaM;
        FieldDerivativeStructure shift = (FieldDerivativeStructure)alphaM.getField().getZero();
        FieldDerivativeStructure alphaEMalphaM = (FieldDerivativeStructure)alphaM.getField().getZero();
        FieldDerivativeStructure cosAlphaE = alphaE.cos();
        FieldDerivativeStructure sinAlphaE = alphaE.sin();
        int iter = 0;
        do {
            FieldDerivativeStructure f2 = ex.multiply(sinAlphaE).subtract(ey.multiply(cosAlphaE));
            FieldDerivativeStructure f1 = ((FieldDerivativeStructure)alphaM.getField().getOne()).subtract(ex.multiply(cosAlphaE)).subtract(ey.multiply(sinAlphaE));
            FieldDerivativeStructure f0 = alphaEMalphaM.subtract(f2);
            FieldDerivativeStructure f12 = f1.multiply(2);
            shift = f0.multiply(f12).divide(f1.multiply(f12).subtract(f0.multiply(f2)));
            alphaEMalphaM = alphaEMalphaM.subtract(shift);
            alphaE = alphaM.add(alphaEMalphaM);
            cosAlphaE = alphaE.cos();
            sinAlphaE = alphaE.sin();
        } while (++iter < 50 && FastMath.abs((double)shift.getValue().getReal()) > 1.0E-12);
        return alphaE;
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return (T)((FieldEHModel)this.models.get(date)).mass;
    }

    public static <T extends RealFieldElement<T>> T normalizeAngle(T a, T center) {
        return (T)((RealFieldElement)a.subtract(Math.PI * 2 * FastMath.floor((double)((a.getReal() + Math.PI - center.getReal()) / (Math.PI * 2)))));
    }

    private static class FieldEHModel<T extends RealFieldElement<T>> {
        private final FDSFactory<T> factory;
        private final FieldCircularOrbit<T> mean;
        private final T mass;
        private final T xnotDot;
        private final T rdpom;
        private final T rdpomp;
        private final T eps1;
        private final T eps2;
        private final T xim;
        private final T ommD;
        private final T rdl;
        private final T aMD;
        private final T kh;
        private final T kl;
        private final T ax1;
        private final T ay1;
        private final T as1;
        private final T ac2;
        private final T axy3;
        private final T as3;
        private final T ac4;
        private final T as5;
        private final T ac6;
        private final T ex1;
        private final T exx2;
        private final T exy2;
        private final T ex3;
        private final T ex4;
        private final T ey1;
        private final T eyx2;
        private final T eyy2;
        private final T ey3;
        private final T ey4;
        private final T rx1;
        private final T ry1;
        private final T r2;
        private final T r3;
        private final T rl;
        private final T iy1;
        private final T ix1;
        private final T i2;
        private final T i3;
        private final T ih;
        private final T lx1;
        private final T ly1;
        private final T l2;
        private final T l3;
        private final T ll;

        FieldEHModel(FDSFactory<T> factory, FieldCircularOrbit<T> mean, T mass, double referenceRadius, double mu, double[] ck0) {
            this.factory = factory;
            this.mean = mean;
            this.mass = mass;
            RealFieldElement zero = (RealFieldElement)mass.getField().getZero();
            RealFieldElement one = (RealFieldElement)mass.getField().getOne();
            RealFieldElement q = (RealFieldElement)((RealFieldElement)zero.add(referenceRadius)).divide(mean.getA());
            RealFieldElement ql = (RealFieldElement)q.multiply((Object)q);
            RealFieldElement g2 = (RealFieldElement)ql.multiply(ck0[2]);
            ql = (RealFieldElement)ql.multiply((Object)q);
            RealFieldElement g3 = (RealFieldElement)ql.multiply(ck0[3]);
            ql = (RealFieldElement)ql.multiply((Object)q);
            RealFieldElement g4 = (RealFieldElement)ql.multiply(ck0[4]);
            ql = (RealFieldElement)ql.multiply((Object)q);
            RealFieldElement g5 = (RealFieldElement)ql.multiply(ck0[5]);
            ql = (RealFieldElement)ql.multiply((Object)q);
            RealFieldElement g6 = (RealFieldElement)ql.multiply(ck0[6]);
            RealFieldElement cosI1 = (RealFieldElement)mean.getI().cos();
            RealFieldElement sinI1 = (RealFieldElement)mean.getI().sin();
            RealFieldElement sinI2 = (RealFieldElement)sinI1.multiply((Object)sinI1);
            RealFieldElement sinI4 = (RealFieldElement)sinI2.multiply((Object)sinI2);
            RealFieldElement sinI6 = (RealFieldElement)sinI2.multiply((Object)sinI4);
            if (sinI2.getReal() < 1.0E-10) {
                throw new OrekitException((Localizable)OrekitMessages.ALMOST_EQUATORIAL_ORBIT, FastMath.toDegrees((double)mean.getI().getReal()));
            }
            if (FastMath.abs((double)(sinI2.getReal() - 0.8)) < 0.001) {
                throw new OrekitException((Localizable)OrekitMessages.ALMOST_CRITICALLY_INCLINED_ORBIT, FastMath.toDegrees((double)mean.getI().getReal()));
            }
            if (mean.getE().getReal() > 0.1) {
                throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL, mean.getE());
            }
            this.xnotDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)zero.add(mu)).divide(mean.getA())).sqrt()).divide(mean.getA());
            this.rdpom = (RealFieldElement)((RealFieldElement)g2.multiply(-0.75)).multiply(((RealFieldElement)sinI2.multiply(-5.0)).add(4.0));
            this.rdpomp = (RealFieldElement)((RealFieldElement)((RealFieldElement)g4.multiply(7.5)).multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(-3.875)).add(1.0)).add(sinI4.multiply(3.0625)))).subtract(((RealFieldElement)g6.multiply(13.125)).multiply(((RealFieldElement)((RealFieldElement)one.subtract(sinI2.multiply(8.0))).add(sinI4.multiply(16.125))).subtract(sinI6.multiply(9.28125))));
            q = (RealFieldElement)((RealFieldElement)zero.add(3.0)).divide(this.rdpom.multiply(32.0));
            this.eps1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)q.multiply((Object)g4)).multiply((Object)sinI2)).multiply(((RealFieldElement)sinI2.multiply(-35.0)).add(30.0))).subtract(((RealFieldElement)((RealFieldElement)((RealFieldElement)q.multiply(175.0)).multiply((Object)g6)).multiply((Object)sinI2)).multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(-3.0)).add(sinI4.multiply(2.0625))).add(1.0)));
            q = (RealFieldElement)((RealFieldElement)sinI1.multiply(3.0)).divide(this.rdpom.multiply(8.0));
            this.eps2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)q.multiply((Object)g3)).multiply(((RealFieldElement)sinI2.multiply(-5.0)).add(4.0))).subtract(((RealFieldElement)q.multiply((Object)g5)).multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(-35.0)).add(sinI4.multiply(26.25))).add(10.0)));
            this.xim = mean.getI();
            this.ommD = (RealFieldElement)cosI1.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)g2.multiply(1.5)).subtract(((RealFieldElement)((RealFieldElement)g2.multiply(2.25)).multiply((Object)g2)).multiply(((RealFieldElement)sinI2.multiply(-3.1666666666666665)).add(2.5)))).add(((RealFieldElement)g4.multiply(0.9375)).multiply(((RealFieldElement)sinI2.multiply(7.0)).subtract(4.0)))).add(((RealFieldElement)g6.multiply(3.28125)).multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(-9.0)).add(2.0)).add(sinI4.multiply(8.25)))));
            this.rdl = (RealFieldElement)((RealFieldElement)((RealFieldElement)g2.multiply(-1.5)).multiply(((RealFieldElement)sinI2.multiply(-4.0)).add(3.0))).add(1.0);
            this.aMD = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.rdl.add(((RealFieldElement)g2.multiply(2.25)).multiply(g2.multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(-21.916666666666668)).add(9.0)).add(sinI4.multiply(14.208333333333334)))))).add(((RealFieldElement)g4.multiply(0.9375)).multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(-31.0)).add(8.0)).add(sinI4.multiply(24.5))))).add(((RealFieldElement)g6.multiply(3.28125)).multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)sinI2.multiply(25.0)).add(-3.3333333333333335)).subtract(sinI4.multiply(48.75))).add(sinI6.multiply(27.5))));
            RealFieldElement qq = (RealFieldElement)((RealFieldElement)g2.divide(this.rdl)).multiply(-1.5);
            RealFieldElement qA = (RealFieldElement)((RealFieldElement)((RealFieldElement)g2.multiply(0.75)).multiply((Object)g2)).multiply((Object)sinI2);
            RealFieldElement qB = (RealFieldElement)((RealFieldElement)g4.multiply(0.25)).multiply((Object)sinI2);
            RealFieldElement qC = (RealFieldElement)((RealFieldElement)g6.multiply(6.5625)).multiply((Object)sinI2);
            RealFieldElement qD = (RealFieldElement)((RealFieldElement)g3.multiply(-0.75)).multiply((Object)sinI1);
            RealFieldElement qE = (RealFieldElement)((RealFieldElement)g5.multiply(3.75)).multiply((Object)sinI1);
            this.kh = (RealFieldElement)((RealFieldElement)zero.add(0.375)).divide(this.rdpom);
            this.kl = (RealFieldElement)this.kh.divide((Object)sinI1);
            this.ax1 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(-3.5)).add(2.0));
            this.ay1 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(-2.5)).add(2.0));
            this.as1 = (RealFieldElement)((RealFieldElement)qD.multiply(((RealFieldElement)sinI2.multiply(-5.0)).add(4.0))).add(qE.multiply(((RealFieldElement)((RealFieldElement)sinI4.multiply(2.625)).add(sinI2.multiply(-3.5))).add(1.0)));
            this.ac2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)qq.multiply((Object)sinI2)).add(((RealFieldElement)qA.multiply(7.0)).multiply(((RealFieldElement)sinI2.multiply(-3.0)).add(2.0)))).add(qB.multiply(((RealFieldElement)sinI2.multiply(-17.5)).add(15.0)))).add(qC.multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(3.0)).subtract(1.0)).subtract(sinI4.multiply(2.0625))));
            this.axy3 = (RealFieldElement)((RealFieldElement)qq.multiply(3.5)).multiply((Object)sinI2);
            this.as3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)qD.multiply(1.6666666666666667)).multiply((Object)sinI2)).add(((RealFieldElement)((RealFieldElement)qE.multiply(1.1666666666666667)).multiply((Object)sinI2)).multiply(((RealFieldElement)sinI2.multiply(-1.125)).add(1.0)));
            this.ac4 = (RealFieldElement)((RealFieldElement)((RealFieldElement)qA.multiply((Object)sinI2)).add(((RealFieldElement)qB.multiply(4.375)).multiply((Object)sinI2))).add(((RealFieldElement)qC.multiply(0.75)).multiply(((RealFieldElement)sinI4.multiply(1.1)).subtract((Object)sinI2)));
            this.as5 = (RealFieldElement)((RealFieldElement)qE.multiply(0.2625)).multiply((Object)sinI4);
            this.ac6 = (RealFieldElement)((RealFieldElement)qC.multiply(-0.1375)).multiply((Object)sinI4);
            this.ex1 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(-1.25)).add(1.0));
            this.exx2 = (RealFieldElement)((RealFieldElement)qq.multiply(0.5)).multiply(((RealFieldElement)sinI2.multiply(-5.0)).add(3.0));
            this.exy2 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(-1.5)).add(2.0));
            this.ex3 = (RealFieldElement)((RealFieldElement)qq.multiply(0.5833333333333334)).multiply((Object)sinI2);
            this.ex4 = (RealFieldElement)((RealFieldElement)qq.multiply(2.125)).multiply((Object)sinI2);
            this.ey1 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(-1.75)).add(1.0));
            this.eyx2 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(-3.0)).add(1.0));
            this.eyy2 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(2.0)).subtract(1.5));
            this.ey3 = (RealFieldElement)((RealFieldElement)qq.multiply(0.5833333333333334)).multiply((Object)sinI2);
            this.ey4 = (RealFieldElement)((RealFieldElement)qq.multiply(2.125)).multiply((Object)sinI2);
            q = (RealFieldElement)((RealFieldElement)cosI1.multiply((Object)qq)).negate();
            this.rx1 = (RealFieldElement)q.multiply(3.5);
            this.ry1 = (RealFieldElement)q.multiply(-2.5);
            this.r2 = (RealFieldElement)q.multiply(-0.5);
            this.r3 = (RealFieldElement)q.multiply(1.1666666666666667);
            this.rl = (RealFieldElement)((RealFieldElement)((RealFieldElement)g3.multiply((Object)cosI1)).multiply(((RealFieldElement)sinI2.multiply(-15.0)).add(4.0))).subtract(((RealFieldElement)((RealFieldElement)g5.multiply(2.5)).multiply((Object)cosI1)).multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(-42.0)).add(4.0)).add(sinI4.multiply(52.5))));
            q = (RealFieldElement)((RealFieldElement)((RealFieldElement)qq.multiply(0.5)).multiply((Object)sinI1)).multiply((Object)cosI1);
            this.iy1 = q;
            this.ix1 = (RealFieldElement)q.negate();
            this.i2 = q;
            this.i3 = (RealFieldElement)q.multiply(2.3333333333333335);
            this.ih = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)g3.negate()).multiply((Object)cosI1)).multiply(((RealFieldElement)sinI2.multiply(-5.0)).add(4.0))).add(((RealFieldElement)((RealFieldElement)g5.multiply(2.5)).multiply((Object)cosI1)).multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(-14.0)).add(4.0)).add(sinI4.multiply(10.5))));
            this.lx1 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(-9.625)).add(7.0));
            this.ly1 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(6.875)).subtract(7.5));
            this.l2 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(1.25)).subtract(0.5));
            this.l3 = (RealFieldElement)qq.multiply(((RealFieldElement)sinI2.multiply(3.2083333333333335)).subtract(1.1666666666666667));
            this.ll = (RealFieldElement)((RealFieldElement)g3.multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(53.0)).subtract(4.0)).add(sinI4.multiply(-57.5)))).add(((RealFieldElement)g5.multiply(2.5)).multiply(((RealFieldElement)((RealFieldElement)sinI2.multiply(-96.0)).add(4.0)).add(((RealFieldElement)sinI4.multiply(269.5)).subtract(sinI6.multiply(183.75)))));
        }

        public FieldDerivativeStructure<T>[] propagateParameters(FieldAbsoluteDate<T> date) {
            Field field = date.durationFrom(this.mean.getDate()).getField();
            RealFieldElement one = (RealFieldElement)field.getOne();
            RealFieldElement zero = (RealFieldElement)field.getZero();
            FieldDerivativeStructure dt = this.factory.build(new RealFieldElement[]{date.durationFrom(this.mean.getDate()), one, zero});
            FieldDerivativeStructure xnot = dt.multiply(this.xnotDot);
            FieldDerivativeStructure x = xnot.multiply((RealFieldElement)this.rdpom.add(this.rdpomp));
            FieldDerivativeStructure cx = x.cos();
            FieldDerivativeStructure sx = x.sin();
            FieldDerivativeStructure exm = cx.multiply(this.mean.getCircularEx()).add(sx.multiply((RealFieldElement)this.eps2.subtract(((RealFieldElement)one.subtract(this.eps1)).multiply(this.mean.getCircularEy()))));
            FieldDerivativeStructure eym = sx.multiply((RealFieldElement)((RealFieldElement)this.eps1.add(1.0)).multiply(this.mean.getCircularEx())).add(cx.multiply((RealFieldElement)this.mean.getCircularEy().subtract(this.eps2))).add(this.eps2);
            FieldDerivativeStructure omm = this.factory.build(new RealFieldElement[]{FieldEcksteinHechlerPropagator.normalizeAngle((RealFieldElement)this.mean.getRightAscensionOfAscendingNode().add(this.ommD.multiply((Object)xnot.getValue())), (RealFieldElement)zero.add(Math.PI)), (RealFieldElement)this.ommD.multiply(this.xnotDot), zero});
            FieldDerivativeStructure xlm = this.factory.build(new RealFieldElement[]{FieldEcksteinHechlerPropagator.normalizeAngle((RealFieldElement)this.mean.getAlphaM().add(this.aMD.multiply((Object)xnot.getValue())), (RealFieldElement)zero.add(Math.PI)), (RealFieldElement)this.aMD.multiply(this.xnotDot), zero});
            FieldDerivativeStructure cl1 = xlm.cos();
            FieldDerivativeStructure sl1 = xlm.sin();
            FieldDerivativeStructure cl2 = cl1.multiply(cl1).subtract(sl1.multiply(sl1));
            FieldDerivativeStructure sl2 = cl1.multiply(sl1).add(sl1.multiply(cl1));
            FieldDerivativeStructure cl3 = cl2.multiply(cl1).subtract(sl2.multiply(sl1));
            FieldDerivativeStructure sl3 = cl2.multiply(sl1).add(sl2.multiply(cl1));
            FieldDerivativeStructure cl4 = cl3.multiply(cl1).subtract(sl3.multiply(sl1));
            FieldDerivativeStructure sl4 = cl3.multiply(sl1).add(sl3.multiply(cl1));
            FieldDerivativeStructure cl5 = cl4.multiply(cl1).subtract(sl4.multiply(sl1));
            FieldDerivativeStructure sl5 = cl4.multiply(sl1).add(sl4.multiply(cl1));
            FieldDerivativeStructure cl6 = cl5.multiply(cl1).subtract(sl5.multiply(sl1));
            FieldDerivativeStructure qh = eym.subtract(this.eps2).multiply(this.kh);
            FieldDerivativeStructure ql = exm.multiply(this.kl);
            FieldDerivativeStructure exmCl1 = exm.multiply(cl1);
            FieldDerivativeStructure exmSl1 = exm.multiply(sl1);
            FieldDerivativeStructure eymCl1 = eym.multiply(cl1);
            FieldDerivativeStructure eymSl1 = eym.multiply(sl1);
            FieldDerivativeStructure exmCl2 = exm.multiply(cl2);
            FieldDerivativeStructure exmSl2 = exm.multiply(sl2);
            FieldDerivativeStructure eymCl2 = eym.multiply(cl2);
            FieldDerivativeStructure eymSl2 = eym.multiply(sl2);
            FieldDerivativeStructure exmCl3 = exm.multiply(cl3);
            FieldDerivativeStructure exmSl3 = exm.multiply(sl3);
            FieldDerivativeStructure eymCl3 = eym.multiply(cl3);
            FieldDerivativeStructure eymSl3 = eym.multiply(sl3);
            FieldDerivativeStructure exmCl4 = exm.multiply(cl4);
            FieldDerivativeStructure exmSl4 = exm.multiply(sl4);
            FieldDerivativeStructure eymCl4 = eym.multiply(cl4);
            FieldDerivativeStructure eymSl4 = eym.multiply(sl4);
            FieldDerivativeStructure rda = exmCl1.multiply(this.ax1).add(eymSl1.multiply(this.ay1)).add(sl1.multiply(this.as1)).add(cl2.multiply(this.ac2)).add(exmCl3.add(eymSl3).multiply(this.axy3)).add(sl3.multiply(this.as3)).add(cl4.multiply(this.ac4)).add(sl5.multiply(this.as5)).add(cl6.multiply(this.ac6));
            FieldDerivativeStructure rdex = cl1.multiply(this.ex1).add(exmCl2.multiply(this.exx2)).add(eymSl2.multiply(this.exy2)).add(cl3.multiply(this.ex3)).add(exmCl4.add(eymSl4).multiply(this.ex4));
            FieldDerivativeStructure rdey = sl1.multiply(this.ey1).add(exmSl2.multiply(this.eyx2)).add(eymCl2.multiply(this.eyy2)).add(sl3.multiply(this.ey3)).add(exmSl4.subtract(eymCl4).multiply(this.ey4));
            FieldDerivativeStructure rdom = exmSl1.multiply(this.rx1).add(eymCl1.multiply(this.ry1)).add(sl2.multiply(this.r2)).add(eymCl3.subtract(exmSl3).multiply(this.r3)).add(ql.multiply(this.rl));
            FieldDerivativeStructure rdxi = eymSl1.multiply(this.iy1).add(exmCl1.multiply(this.ix1)).add(cl2.multiply(this.i2)).add(exmCl3.add(eymSl3).multiply(this.i3)).add(qh.multiply(this.ih));
            FieldDerivativeStructure rdxl = exmSl1.multiply(this.lx1).add(eymCl1.multiply(this.ly1)).add(sl2.multiply(this.l2)).add(exmSl3.subtract(eymCl3).multiply(this.l3)).add(ql.multiply(this.ll));
            FieldDerivativeStructure[] FTD = (FieldDerivativeStructure[])MathArrays.buildArray((Field)rdxl.getField(), (int)6);
            FTD[0] = rda.add(1.0).multiply(this.mean.getA());
            FTD[1] = rdex.add(exm);
            FTD[2] = rdey.add(eym);
            FTD[3] = rdxi.add(this.xim);
            FTD[4] = rdom.add(omm);
            FTD[5] = rdxl.add(xlm);
            return FTD;
        }
    }
}

