/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.models.earth.DiscreteTroposphericModel;
import org.orekit.models.earth.MappingFunction;
import org.orekit.models.earth.SaastamoinenModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class EstimatedTroposphericModel
implements DiscreteTroposphericModel {
    public static final String TOTAL_ZENITH_DELAY = "total zenith delay";
    private static final long serialVersionUID = 3550108249909528948L;
    private final MappingFunction model;
    private final ParameterDriver totalZenithDelay;
    private double t0;
    private double p0;

    public EstimatedTroposphericModel(double t0, double p0, MappingFunction model, double totalDelay) {
        this.totalZenithDelay = new ParameterDriver(TOTAL_ZENITH_DELAY, totalDelay, FastMath.scalb((double)1.0, (int)0), 0.0, Double.POSITIVE_INFINITY);
        this.t0 = t0;
        this.p0 = p0;
        this.model = model;
    }

    public EstimatedTroposphericModel(MappingFunction model, double totalDelay) {
        this(291.15, 1013.25, model, totalDelay);
    }

    @Override
    public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        return this.model.mappingFactors(elevation, height, parameters, date);
    }

    @Override
    public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        return this.model.mappingFactors((RealFieldElement)elevation, (RealFieldElement)height, (RealFieldElement[])parameters, date);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.totalZenithDelay);
    }

    @Override
    public double pathDelay(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double[] mf = this.mappingFactors(elevation, height, parameters, date);
        double[] delays = this.computeZenithDelay(height, parameters, date);
        return mf[0] * delays[0] + mf[1] * (delays[1] - delays[0]);
    }

    @Override
    public <T extends RealFieldElement<T>> T pathDelay(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement[] mf = this.mappingFactors((RealFieldElement)elevation, (RealFieldElement)height, (RealFieldElement[])parameters, date);
        RealFieldElement[] delays = this.computeZenithDelay((RealFieldElement)height, (RealFieldElement[])parameters, date);
        return (T)((RealFieldElement)((RealFieldElement)mf[0].multiply((Object)delays[0])).add(mf[1].multiply(delays[1].subtract((Object)delays[0]))));
    }

    @Override
    public double[] computeZenithDelay(double height, double[] parameters, AbsoluteDate date) {
        SaastamoinenModel saastamoinen = new SaastamoinenModel(this.t0, this.p0, 0.0, (String)null);
        double zhd = saastamoinen.pathDelay(1.5707963267948966, height, parameters, date);
        double ztd = parameters[0];
        return new double[]{zhd, ztd};
    }

    @Override
    public <T extends RealFieldElement<T>> T[] computeZenithDelay(T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        SaastamoinenModel saastamoinen = new SaastamoinenModel(this.t0, this.p0, 0.0, (String)null);
        RealFieldElement zhd = saastamoinen.pathDelay((RealFieldElement)zero.add(1.5707963267948966), (RealFieldElement)height, (RealFieldElement[])parameters, date);
        T ztd = parameters[0];
        RealFieldElement[] delays = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        delays[0] = zhd;
        delays[1] = ztd;
        return delays;
    }
}

