/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.models.earth.IonosphericModel;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;
import org.orekit.utils.StateFunction;

public class RangeRateIonosphericDelayModifier
implements EstimationModifier<RangeRate> {
    private final IonosphericModel ionoModel;
    private final double fTwoWay;

    public RangeRateIonosphericDelayModifier(IonosphericModel model, boolean twoWay) {
        this.ionoModel = model;
        this.fTwoWay = twoWay ? 2.0 : 1.0;
    }

    private double rangeRateErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        double dt = 10.0;
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double azimuth = station.getBaseFrame().getAzimuth(position, state.getFrame(), state.getDate());
            double delay1 = this.ionoModel.pathDelay(state.getDate(), station.getBaseFrame().getPoint(), elevation, azimuth);
            SpacecraftState state2 = state.shiftedBy(10.0);
            Vector3D position2 = state2.getPVCoordinates().getPosition();
            double elevation2 = station.getBaseFrame().getElevation(position2, state2.getFrame(), state2.getDate());
            double azimuth2 = station.getBaseFrame().getAzimuth(position2, state2.getFrame(), state2.getDate());
            double delay2 = this.ionoModel.pathDelay(state2.getDate(), station.getBaseFrame().getPoint(), elevation2, azimuth2);
            return this.fTwoWay * (delay2 - delay1) / 10.0;
        }
        return 0.0;
    }

    private double[][] rangeErrorJacobianState(final GroundStation station, SpacecraftState refstate) {
        double[][] finiteDifferencesJacobian = Differentiation.differentiate(new StateFunction(){

            @Override
            public double[] value(SpacecraftState state) {
                double value = RangeRateIonosphericDelayModifier.this.rangeRateErrorIonosphericModel(station, state);
                return new double[]{value};
            }
        }, 1, Propagator.DEFAULT_LAW, OrbitType.CARTESIAN, PositionAngle.TRUE, 15.0, 3).value(refstate);
        return finiteDifferencesJacobian;
    }

    private double rangeRateErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state, double delay) {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) {
                return RangeRateIonosphericDelayModifier.this.rangeRateErrorIonosphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return rangeErrorDerivative.value(driver);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<RangeRate> estimated) {
        RangeRate measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        double delay = this.rangeRateErrorIonosphericModel(station, state);
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + delay;
        estimated.setEstimatedValue(newValue);
        double[][] djac = this.rangeErrorJacobianState(station, state);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            double parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeRateErrorParameterDerivative(station, driver, state, delay));
        }
    }
}

