/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.rank;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractUnivariateStatistic;
import org.hipparchus.stat.descriptive.rank.Percentile;
import org.hipparchus.stat.ranking.NaNStrategy;
import org.hipparchus.util.KthSelector;

public class Median
extends AbstractUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private static final double FIXED_QUANTILE_50 = 50.0;
    private final Percentile percentile;

    public Median() {
        this.percentile = new Percentile(50.0);
    }

    private Median(Percentile.EstimationType estimationType, NaNStrategy nanStrategy, KthSelector kthSelector) throws MathIllegalArgumentException {
        this.percentile = new Percentile(50.0, estimationType, nanStrategy, kthSelector);
    }

    Median(Median original) throws NullArgumentException {
        super(original);
        this.percentile = original.percentile.copy();
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return this.percentile.evaluate(values, begin, length);
    }

    @Override
    public Median copy() {
        return new Median(this);
    }

    public Percentile.EstimationType getEstimationType() {
        return this.percentile.getEstimationType();
    }

    public Median withEstimationType(Percentile.EstimationType newEstimationType) {
        return new Median(newEstimationType, this.percentile.getNaNStrategy(), this.percentile.getKthSelector());
    }

    public NaNStrategy getNaNStrategy() {
        return this.percentile.getNaNStrategy();
    }

    public Median withNaNStrategy(NaNStrategy newNaNStrategy) {
        return new Median(this.percentile.getEstimationType(), newNaNStrategy, this.percentile.getKthSelector());
    }

    public KthSelector getKthSelector() {
        return this.percentile.getKthSelector();
    }

    public Median withKthSelector(KthSelector newKthSelector) {
        return new Median(this.percentile.getEstimationType(), this.percentile.getNaNStrategy(), newKthSelector);
    }
}

