/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.antenna;

import java.util.HashMap;
import java.util.Map;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.BeidouGeo;
import org.orekit.gnss.attitude.BeidouIGSO;
import org.orekit.gnss.attitude.BeidouMeo;
import org.orekit.gnss.attitude.GNSSAttitudeProvider;
import org.orekit.gnss.attitude.GPSBlockIIA;
import org.orekit.gnss.attitude.GPSBlockIIF;
import org.orekit.gnss.attitude.GPSBlockIIR;
import org.orekit.gnss.attitude.Galileo;
import org.orekit.gnss.attitude.GenericGNSS;
import org.orekit.gnss.attitude.Glonass;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;

public enum SatelliteType {
    BEIDOU_2G("BEIDOU-2G"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new BeidouGeo(validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BEIDOU_2I("BEIDOU-2I"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new BeidouIGSO(validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BEIDOU_2M("BEIDOU-2M"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new BeidouMeo(validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BEIDOU_3I("BEIDOU-3I"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new Galileo(Galileo.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BLOCK_I("BLOCK I"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GPSBlockIIA(GPSBlockIIA.DEFAULT_YAW_RATES[prnNumber], GPSBlockIIA.DEFAULT_YAW_BIAS, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BLOCK_II("BLOCK II"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GPSBlockIIA(GPSBlockIIA.DEFAULT_YAW_RATES[prnNumber], GPSBlockIIA.DEFAULT_YAW_BIAS, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BLOCK_IIA("BLOCK IIA"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GPSBlockIIA(GPSBlockIIA.DEFAULT_YAW_RATES[prnNumber], GPSBlockIIA.DEFAULT_YAW_BIAS, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BLOCK_IIR_A("BLOCK IIR-A"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GPSBlockIIR(GPSBlockIIR.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BLOCK_IIR_B("BLOCK IIR-B"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GPSBlockIIR(GPSBlockIIR.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BLOCK_IIR_M("BLOCK IIR-M"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GPSBlockIIR(GPSBlockIIR.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BLOCK_IIF("BLOCK IIF"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GPSBlockIIF(GPSBlockIIF.DEFAULT_YAW_RATE, GPSBlockIIF.DEFAULT_YAW_BIAS, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    BLOCK_IIIA("BLOCK IIIA"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GPSBlockIIF(GPSBlockIIF.DEFAULT_YAW_RATE, GPSBlockIIF.DEFAULT_YAW_BIAS, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    GALILEO_0A("GALILEO-0A"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new Galileo(Galileo.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    GALILEO_0B("GALILEO-0B"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new Galileo(Galileo.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    GALILEO_1("GALILEO-1"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new Galileo(Galileo.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    GALILEO_2("GALILEO-2"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new Galileo(Galileo.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    GLONASS("GLONASS"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new Glonass(Glonass.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    GLONASS_M("GLONASS-M"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new Glonass(Glonass.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    GLONASS_K1("GLONASS-K1"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new Glonass(Glonass.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    GLONASS_K2("GLONASS-K2"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new Glonass(Glonass.DEFAULT_YAW_RATE, validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    IRNSS_1GEO("IRNSS-1GEO"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GenericGNSS(validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    IRNSS_1IGSO("IRNSS-1IGSO"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GenericGNSS(validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    QZSS("QZSS"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GenericGNSS(validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    QZSS_2I("QZSS-2I"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GenericGNSS(validityStart, validityEnd, sun, inertialFrame);
        }
    }
    ,
    QZSS_2G("QZSS-2G"){

        @Override
        public GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
            return new GenericGNSS(validityStart, validityEnd, sun, inertialFrame);
        }
    };

    private static final Map<String, SatelliteType> NAMES_MAP;
    private final String name;

    private SatelliteType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract GNSSAttitudeProvider buildAttitudeProvider(AbsoluteDate var1, AbsoluteDate var2, ExtendedPVCoordinatesProvider var3, Frame var4, int var5);

    public static SatelliteType parseSatelliteType(String s) throws OrekitIllegalArgumentException {
        SatelliteType satelliteAntennaCode = NAMES_MAP.get(s);
        if (satelliteAntennaCode == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_SATELLITE_ANTENNA_CODE, s);
        }
        return satelliteAntennaCode;
    }

    static {
        NAMES_MAP = new HashMap<String, SatelliteType>();
        for (SatelliteType satelliteAntennaCode : SatelliteType.values()) {
            NAMES_MAP.put(satelliteAntennaCode.getName(), satelliteAntennaCode);
            NAMES_MAP.put(satelliteAntennaCode.getName().replaceAll("[-_ ]", ""), satelliteAntennaCode);
        }
    }
}

