/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.Position;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class PositionBuilder
extends AbstractMeasurementBuilder<Position> {
    public PositionBuilder(CorrelatedRandomVectorGenerator noiseSource, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
    }

    @Override
    public Position build(SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites()[0];
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState state = states[satellite.getPropagatorIndex()];
        Position dummy = new Position(state.getDate(), Vector3D.NaN, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double[] position = dummy.estimate(0, 0, states).getEstimatedValue();
        double[] noise = this.getNoise();
        if (noise != null) {
            position[0] = position[0] + noise[0];
            position[1] = position[1] + noise[1];
            position[2] = position[2] + noise[2];
        }
        Position measurement = new Position(state.getDate(), new Vector3D(position), sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

