/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.random;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.hipparchus.distribution.EnumeratedDistribution;
import org.hipparchus.distribution.IntegerDistribution;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.BetaDistribution;
import org.hipparchus.distribution.continuous.EnumeratedRealDistribution;
import org.hipparchus.distribution.continuous.ExponentialDistribution;
import org.hipparchus.distribution.continuous.GammaDistribution;
import org.hipparchus.distribution.continuous.LogNormalDistribution;
import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.distribution.continuous.UniformRealDistribution;
import org.hipparchus.distribution.discrete.EnumeratedIntegerDistribution;
import org.hipparchus.distribution.discrete.PoissonDistribution;
import org.hipparchus.distribution.discrete.UniformIntegerDistribution;
import org.hipparchus.distribution.discrete.ZipfDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.random.ForwardingRandomGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.Well19937c;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Pair;
import org.hipparchus.util.Precision;
import org.hipparchus.util.ResizableDoubleArray;

public class RandomDataGenerator
extends ForwardingRandomGenerator
implements RandomGenerator,
Serializable {
    private static final long serialVersionUID = 20160529L;
    private static final double[] EXPONENTIAL_SA_QI;
    private static final Map<Class<? extends RealDistribution>, RealDistributionSampler> CONTINUOUS_SAMPLERS;
    private static final Map<Class<? extends IntegerDistribution>, IntegerDistributionSampler> DISCRETE_SAMPLERS;
    private static final RealDistributionSampler DEFAULT_REAL_SAMPLER;
    private static final IntegerDistributionSampler DEFAULT_INTEGER_SAMPLER;
    private final RandomGenerator randomGenerator;
    private transient ZipfRejectionInversionSampler zipfSampler;

    public RandomDataGenerator() {
        this(new Well19937c());
    }

    public RandomDataGenerator(long seed) {
        this(new Well19937c(seed));
    }

    private RandomDataGenerator(RandomGenerator randomGenerator) {
        MathUtils.checkNotNull(randomGenerator);
        this.randomGenerator = randomGenerator;
    }

    public static RandomDataGenerator of(RandomGenerator randomGenerator) {
        return new RandomDataGenerator(randomGenerator);
    }

    @Override
    protected RandomGenerator delegate() {
        return this.randomGenerator;
    }

    public double nextBeta(double alpha, double beta) {
        return ChengBetaSampler.sample(this.randomGenerator, alpha, beta);
    }

    public double nextExponential(double mean) {
        double u2;
        double u;
        if (mean <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.MEAN, mean);
        }
        double a = 0.0;
        for (u = this.randomGenerator.nextDouble(); u < 0.5; u *= 2.0) {
            a += EXPONENTIAL_SA_QI[0];
        }
        if ((u += u - 1.0) <= EXPONENTIAL_SA_QI[0]) {
            return mean * (a + u);
        }
        int i = 0;
        double umin = u2 = this.randomGenerator.nextDouble();
        do {
            ++i;
            u2 = this.randomGenerator.nextDouble();
            if (!(u2 < umin)) continue;
            umin = u2;
        } while (u > EXPONENTIAL_SA_QI[i]);
        return mean * (a + umin * EXPONENTIAL_SA_QI[0]);
    }

    public double nextGamma(double shape, double scale) {
        double v;
        if (shape < 1.0) {
            double x;
            while (true) {
                double u2;
                double u;
                double bGS;
                double p;
                if ((p = (bGS = 1.0 + shape / Math.E) * (u = this.randomGenerator.nextDouble())) <= 1.0) {
                    x = FastMath.pow(p, 1.0 / shape);
                    u2 = this.randomGenerator.nextDouble();
                    if (u2 > FastMath.exp(-x)) continue;
                    return scale * x;
                }
                x = -1.0 * FastMath.log((bGS - p) / shape);
                u2 = this.randomGenerator.nextDouble();
                if (!(u2 > FastMath.pow(x, shape - 1.0))) break;
            }
            return scale * x;
        }
        double d = shape - 0.3333333333333333;
        double c = 1.0 / (3.0 * FastMath.sqrt(d));
        while (true) {
            double x;
            if ((v = (1.0 + c * (x = this.randomGenerator.nextGaussian())) * (1.0 + c * x) * (1.0 + c * x)) <= 0.0) {
                continue;
            }
            double x2 = x * x;
            double u = this.randomGenerator.nextDouble();
            if (u < 1.0 - 0.0331 * x2 * x2) {
                return scale * d * v;
            }
            if (FastMath.log(u) < 0.5 * x2 + d * (1.0 - v + FastMath.log(v))) break;
        }
        return scale * d * v;
    }

    public double nextNormal(double mean, double standardDeviation) {
        if (standardDeviation <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, standardDeviation, 0);
        }
        return standardDeviation * this.nextGaussian() + mean;
    }

    public double nextLogNormal(double shape, double scale) {
        if (shape <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, shape, 0);
        }
        return FastMath.exp(scale + shape * this.nextGaussian());
    }

    public int nextPoisson(double mean) {
        double y;
        long y2;
        block10: {
            if (mean <= 0.0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, mean, 0);
            }
            double pivot = 40.0;
            if (mean < 40.0) {
                double p = FastMath.exp(-mean);
                long n = 0L;
                double r = 1.0;
                double rnd = 1.0;
                while ((double)n < 1000.0 * mean) {
                    rnd = this.randomGenerator.nextDouble();
                    if ((r *= rnd) >= p) {
                        ++n;
                        continue;
                    }
                    return (int)FastMath.min(n, Integer.MAX_VALUE);
                }
                return (int)FastMath.min(n, Integer.MAX_VALUE);
            }
            double lambda = FastMath.floor(mean);
            double lambdaFractional = mean - lambda;
            double logLambda = FastMath.log(lambda);
            double logLambdaFactorial = CombinatoricsUtils.factorialLog((int)lambda);
            y2 = lambdaFractional < Double.MIN_VALUE ? 0L : (long)this.nextPoisson(lambdaFractional);
            double delta = FastMath.sqrt(lambda * FastMath.log(32.0 * lambda / Math.PI + 1.0));
            double halfDelta = delta / 2.0;
            double twolpd = 2.0 * lambda + delta;
            double a1 = FastMath.sqrt(Math.PI * twolpd) * FastMath.exp(1.0 / (8.0 * lambda));
            double a2 = twolpd / delta * FastMath.exp(-delta * (1.0 + delta) / twolpd);
            double aSum = a1 + a2 + 1.0;
            double p1 = a1 / aSum;
            double p2 = a2 / aSum;
            double c1 = 1.0 / (8.0 * lambda);
            double x = 0.0;
            y = 0.0;
            double v = 0.0;
            boolean a = false;
            double t = 0.0;
            double qr = 0.0;
            double qa = 0.0;
            while (true) {
                double u;
                if ((u = this.randomGenerator.nextDouble()) <= p1) {
                    double n = this.randomGenerator.nextGaussian();
                    x = n * FastMath.sqrt(lambda + halfDelta) - 0.5;
                    if (x > delta || x < -lambda) continue;
                    y = x < 0.0 ? FastMath.floor(x) : FastMath.ceil(x);
                    double e = this.nextExponential(1.0);
                    v = -e - n * n / 2.0 + c1;
                } else {
                    if (u > p1 + p2) {
                        y = lambda;
                        break block10;
                    }
                    x = delta + twolpd / delta * this.nextExponential(1.0);
                    y = FastMath.ceil(x);
                    v = -this.nextExponential(1.0) - delta * (x + 1.0) / twolpd;
                }
                a = x < 0.0;
                t = y * (y + 1.0) / (2.0 * lambda);
                if (v < -t && !a) {
                    y = lambda + y;
                    break block10;
                }
                qr = t * ((2.0 * y + 1.0) / (6.0 * lambda) - 1.0);
                qa = qr - t * t / (3.0 * (lambda + (double)a * (y + 1.0)));
                if (v < qa) {
                    y = lambda + y;
                    break block10;
                }
                if (!(v > qr) && v < y * logLambda - CombinatoricsUtils.factorialLog((int)(y + lambda)) + logLambdaFactorial) break;
            }
            y = lambda + y;
        }
        return (int)FastMath.min(y2 + (long)y, Integer.MAX_VALUE);
    }

    public double nextDeviate(RealDistribution dist) {
        return this.getSampler(dist).nextSample(this, dist);
    }

    public double[] nextDeviates(RealDistribution dist, int size) {
        RealDistributionSampler sampler = this.getSampler(dist);
        double[] out = new double[size];
        for (int i = 0; i < size; ++i) {
            out[i] = sampler.nextSample(this, dist);
        }
        return out;
    }

    public int nextDeviate(IntegerDistribution dist) {
        return this.getSampler(dist).nextSample(this, dist);
    }

    public int[] nextDeviates(IntegerDistribution dist, int size) {
        IntegerDistributionSampler sampler = this.getSampler(dist);
        int[] out = new int[size];
        for (int i = 0; i < size; ++i) {
            out[i] = sampler.nextSample(this, dist);
        }
        return out;
    }

    private RealDistributionSampler getSampler(RealDistribution dist) {
        RealDistributionSampler sampler = CONTINUOUS_SAMPLERS.get(dist.getClass());
        if (sampler != null) {
            return sampler;
        }
        return DEFAULT_REAL_SAMPLER;
    }

    private IntegerDistributionSampler getSampler(IntegerDistribution dist) {
        IntegerDistributionSampler sampler = DISCRETE_SAMPLERS.get(dist.getClass());
        if (sampler != null) {
            return sampler;
        }
        return DEFAULT_INTEGER_SAMPLER;
    }

    public int nextInt(int lower, int upper) {
        if (lower >= upper) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, lower, upper);
        }
        int max = upper - lower + 1;
        if (max <= 0) {
            int r;
            while ((r = this.nextInt()) < lower || r > upper) {
            }
            return r;
        }
        return lower + this.nextInt(max);
    }

    public long nextLong(long lower, long upper) throws MathIllegalArgumentException {
        if (lower >= upper) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, lower, upper);
        }
        long max = upper - lower + 1L;
        if (max <= 0L) {
            long r;
            while ((r = this.randomGenerator.nextLong()) < lower || r > upper) {
            }
            return r;
        }
        if (max < Integer.MAX_VALUE) {
            return lower + (long)this.randomGenerator.nextInt((int)max);
        }
        return lower + this.nextLong(max);
    }

    public double nextUniform(double lower, double upper) {
        if (upper <= lower) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, lower, upper);
        }
        if (Double.isInfinite(lower) || Double.isInfinite(upper)) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INFINITE_BOUND, new Object[0]);
        }
        if (Double.isNaN(lower) || Double.isNaN(upper)) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NAN_NOT_ALLOWED, new Object[0]);
        }
        double u = this.randomGenerator.nextDouble();
        return u * upper + (1.0 - u) * lower;
    }

    public int nextZipf(int numberOfElements, double exponent) {
        if (this.zipfSampler == null || this.zipfSampler.getExponent() != exponent || this.zipfSampler.getNumberOfElements() != numberOfElements) {
            this.zipfSampler = new ZipfRejectionInversionSampler(numberOfElements, exponent);
        }
        return this.zipfSampler.sample(this.randomGenerator);
    }

    public String nextHexString(int len) throws MathIllegalArgumentException {
        if (len <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LENGTH, len);
        }
        StringBuilder outBuffer = new StringBuilder();
        byte[] randomBytes = new byte[len / 2 + 1];
        this.randomGenerator.nextBytes(randomBytes);
        for (int i = 0; i < randomBytes.length; ++i) {
            Integer c = randomBytes[i];
            String hex = Integer.toHexString(c + 128);
            if (hex.length() == 1) {
                outBuffer.append('0');
            }
            outBuffer.append(hex);
        }
        return outBuffer.toString().substring(0, len);
    }

    public int[] nextPermutation(int n, int k) throws MathIllegalArgumentException {
        if (k > n) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.PERMUTATION_EXCEEDS_N, k, n, true);
        }
        if (k <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.PERMUTATION_SIZE, k);
        }
        int[] index = MathArrays.natural(n);
        MathArrays.shuffle(index, this.randomGenerator);
        return Arrays.copyOf(index, k);
    }

    public Object[] nextSample(Collection<?> c, int k) throws MathIllegalArgumentException {
        int len = c.size();
        if (k > len) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, k, len, true);
        }
        if (k <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_SAMPLES, k);
        }
        Object[] objects = c.toArray();
        int[] index = this.nextPermutation(len, k);
        Object[] result = new Object[k];
        for (int i = 0; i < k; ++i) {
            result[i] = objects[index[i]];
        }
        return result;
    }

    public double[] nextSample(double[] a, int k) throws MathIllegalArgumentException {
        int len = a.length;
        if (k > len) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, k, len, true);
        }
        if (k <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_SAMPLES, k);
        }
        int[] index = this.nextPermutation(len, k);
        double[] result = new double[k];
        for (int i = 0; i < k; ++i) {
            result[i] = a[index[i]];
        }
        return result;
    }

    public int[] nextSampleWithReplacement(int sampleSize, double[] weights) {
        if (sampleSize < 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, new Object[0]);
        }
        double[] normWt = EnumeratedDistribution.checkAndNormalize(weights);
        int[] out = new int[sampleSize];
        int len = normWt.length;
        for (int i = 0; i < sampleSize; ++i) {
            double u = this.randomGenerator.nextDouble();
            int j = 1;
            for (double cum = normWt[0]; cum < u && j < len; cum += normWt[j++]) {
            }
            out[i] = --j;
        }
        return out;
    }

    static {
        CONTINUOUS_SAMPLERS = new ConcurrentHashMap<Class<? extends RealDistribution>, RealDistributionSampler>();
        DISCRETE_SAMPLERS = new ConcurrentHashMap<Class<? extends IntegerDistribution>, IntegerDistributionSampler>();
        DEFAULT_REAL_SAMPLER = (generator, dist) -> dist.inverseCumulativeProbability(generator.nextDouble());
        DEFAULT_INTEGER_SAMPLER = (generator, dist) -> dist.inverseCumulativeProbability(generator.nextDouble());
        double LN2 = FastMath.log(2.0);
        double qi = 0.0;
        int i = 1;
        ResizableDoubleArray ra = new ResizableDoubleArray(20);
        while (qi < 1.0) {
            ra.addElement(qi += FastMath.pow(LN2, i) / (double)CombinatoricsUtils.factorial(i));
            ++i;
        }
        EXPONENTIAL_SA_QI = ra.getElements();
        CONTINUOUS_SAMPLERS.put(BetaDistribution.class, (generator, dist) -> {
            BetaDistribution beta = (BetaDistribution)dist;
            return generator.nextBeta(beta.getAlpha(), beta.getBeta());
        });
        CONTINUOUS_SAMPLERS.put(ExponentialDistribution.class, (generator, dist) -> generator.nextExponential(dist.getNumericalMean()));
        CONTINUOUS_SAMPLERS.put(GammaDistribution.class, (generator, dist) -> {
            GammaDistribution gamma = (GammaDistribution)dist;
            return generator.nextGamma(gamma.getShape(), gamma.getScale());
        });
        CONTINUOUS_SAMPLERS.put(NormalDistribution.class, (generator, dist) -> {
            NormalDistribution normal = (NormalDistribution)dist;
            return generator.nextNormal(normal.getMean(), normal.getStandardDeviation());
        });
        CONTINUOUS_SAMPLERS.put(LogNormalDistribution.class, (generator, dist) -> {
            LogNormalDistribution logNormal = (LogNormalDistribution)dist;
            return generator.nextLogNormal(logNormal.getShape(), logNormal.getLocation());
        });
        CONTINUOUS_SAMPLERS.put(UniformRealDistribution.class, (generator, dist) -> generator.nextUniform(dist.getSupportLowerBound(), dist.getSupportUpperBound()));
        CONTINUOUS_SAMPLERS.put(EnumeratedRealDistribution.class, (generator, dist) -> {
            EnumeratedRealDistribution edist = (EnumeratedRealDistribution)dist;
            RandomDataGenerator randomDataGenerator = generator;
            Objects.requireNonNull(randomDataGenerator);
            EnumeratedDistributionSampler sampler = randomDataGenerator.new EnumeratedDistributionSampler(edist.getPmf());
            return (Double)sampler.sample();
        });
        DISCRETE_SAMPLERS.put(PoissonDistribution.class, (generator, dist) -> generator.nextPoisson(dist.getNumericalMean()));
        DISCRETE_SAMPLERS.put(UniformIntegerDistribution.class, (generator, dist) -> generator.nextInt(dist.getSupportLowerBound(), dist.getSupportUpperBound()));
        DISCRETE_SAMPLERS.put(ZipfDistribution.class, (generator, dist) -> {
            ZipfDistribution zipfDist = (ZipfDistribution)dist;
            return generator.nextZipf(zipfDist.getNumberOfElements(), zipfDist.getExponent());
        });
        DISCRETE_SAMPLERS.put(EnumeratedIntegerDistribution.class, (generator, dist) -> {
            EnumeratedIntegerDistribution edist = (EnumeratedIntegerDistribution)dist;
            RandomDataGenerator randomDataGenerator = generator;
            Objects.requireNonNull(randomDataGenerator);
            EnumeratedDistributionSampler sampler = randomDataGenerator.new EnumeratedDistributionSampler(edist.getPmf());
            return (Integer)sampler.sample();
        });
    }

    private final class EnumeratedDistributionSampler<T> {
        private final double[] weights;
        private final List<T> values;

        EnumeratedDistributionSampler(List<Pair<T, Double>> pmf) {
            int numMasses = pmf.size();
            this.weights = new double[numMasses];
            this.values = new ArrayList<T>();
            for (int i = 0; i < numMasses; ++i) {
                this.weights[i] = pmf.get(i).getSecond();
                this.values.add(pmf.get(i).getFirst());
            }
        }

        public T sample() {
            int[] chosen = RandomDataGenerator.this.nextSampleWithReplacement(1, this.weights);
            return this.values.get(chosen[0]);
        }
    }

    static final class ZipfRejectionInversionSampler {
        private final double exponent;
        private final int numberOfElements;
        private final double hIntegralX1;
        private final double hIntegralNumberOfElements;
        private final double s;

        ZipfRejectionInversionSampler(int numberOfElements, double exponent) {
            this.exponent = exponent;
            this.numberOfElements = numberOfElements;
            this.hIntegralX1 = this.hIntegral(1.5) - 1.0;
            this.hIntegralNumberOfElements = this.hIntegral((double)numberOfElements + 0.5);
            this.s = 2.0 - this.hIntegralInverse(this.hIntegral(2.5) - this.h(2.0));
        }

        int sample(RandomGenerator random) {
            double u;
            double x;
            int k;
            do {
                if ((k = (int)((x = this.hIntegralInverse(u = this.hIntegralNumberOfElements + random.nextDouble() * (this.hIntegralX1 - this.hIntegralNumberOfElements))) + 0.5)) < 1) {
                    k = 1;
                    continue;
                }
                if (k <= this.numberOfElements) continue;
                k = this.numberOfElements;
            } while (!((double)k - x <= this.s) && !(u >= this.hIntegral((double)k + 0.5) - this.h(k)));
            return k;
        }

        private double hIntegral(double x) {
            double logX = FastMath.log(x);
            return ZipfRejectionInversionSampler.helper2((1.0 - this.exponent) * logX) * logX;
        }

        private double h(double x) {
            return FastMath.exp(-this.exponent * FastMath.log(x));
        }

        private double hIntegralInverse(double x) {
            double t = x * (1.0 - this.exponent);
            if (t < -1.0) {
                t = -1.0;
            }
            return FastMath.exp(ZipfRejectionInversionSampler.helper1(t) * x);
        }

        public double getExponent() {
            return this.exponent;
        }

        public int getNumberOfElements() {
            return this.numberOfElements;
        }

        static double helper1(double x) {
            if (FastMath.abs(x) > 1.0E-8) {
                return FastMath.log1p(x) / x;
            }
            return 1.0 - x * (0.5 - x * (0.3333333333333333 - x * 0.25));
        }

        static double helper2(double x) {
            if (FastMath.abs(x) > 1.0E-8) {
                return FastMath.expm1(x) / x;
            }
            return 1.0 + x * 0.5 * (1.0 + x * 0.3333333333333333 * (1.0 + x * 0.25));
        }
    }

    private static class ChengBetaSampler {
        private ChengBetaSampler() {
        }

        public static double sample(RandomGenerator generator, double alpha, double beta) {
            double a = FastMath.min(alpha, beta);
            double b = FastMath.max(alpha, beta);
            if (a > 1.0) {
                return ChengBetaSampler.algorithmBB(generator, alpha, a, b);
            }
            return ChengBetaSampler.algorithmBC(generator, alpha, b, a);
        }

        private static double algorithmBB(RandomGenerator generator, double a0, double a, double b) {
            double t;
            double u2;
            double z;
            double w;
            double u1;
            double v;
            double r;
            double s;
            double alpha = a + b;
            double beta = FastMath.sqrt((alpha - 2.0) / (2.0 * a * b - alpha));
            double gamma = a + 1.0 / beta;
            do {
                u1 = generator.nextDouble();
                u2 = generator.nextDouble();
            } while (!((s = a + (r = gamma * (v = beta * (FastMath.log(u1) - FastMath.log1p(-u1))) - 1.3862944) - (w = a * FastMath.exp(v))) + 2.609438 >= 5.0 * (z = u1 * u1 * u2)) && !(s >= (t = FastMath.log(z))) && r + alpha * (FastMath.log(alpha) - FastMath.log(b + w)) < t);
            w = FastMath.min(w, Double.MAX_VALUE);
            return Precision.equals(a, a0) ? w / (b + w) : b / (b + w);
        }

        private static double algorithmBC(RandomGenerator generator, double a0, double a, double b) {
            double w;
            double alpha = a + b;
            double beta = 1.0 / b;
            double delta = 1.0 + a - b;
            double k1 = delta * (0.0138889 + 0.0416667 * b) / (a * beta - 0.777778);
            double k2 = 0.25 + (0.5 + 0.25 / delta) * b;
            while (true) {
                double v;
                double u1 = generator.nextDouble();
                double u2 = generator.nextDouble();
                double y = u1 * u2;
                double z = u1 * y;
                if (u1 < 0.5) {
                    if (0.25 * u2 + z - y >= k1) {
                        continue;
                    }
                } else {
                    if (z <= 0.25) {
                        v = beta * (FastMath.log(u1) - FastMath.log1p(-u1));
                        w = a * FastMath.exp(v);
                        break;
                    }
                    if (z >= k2) continue;
                }
                v = beta * (FastMath.log(u1) - FastMath.log1p(-u1));
                w = a * FastMath.exp(v);
                if (alpha * (FastMath.log(alpha) - FastMath.log(b + w) + v) - 1.3862944 >= FastMath.log(z)) break;
            }
            w = FastMath.min(w, Double.MAX_VALUE);
            return Precision.equals(a, a0) ? w / (b + w) : b / (b + w);
        }
    }

    @FunctionalInterface
    private static interface IntegerDistributionSampler {
        public int nextSample(RandomDataGenerator var1, IntegerDistribution var2);
    }

    @FunctionalInterface
    private static interface RealDistributionSampler {
        public double nextSample(RandomDataGenerator var1, RealDistribution var2);
    }
}

