/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.interval;

import org.hipparchus.distribution.continuous.FDistribution;
import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.LocalizedStatFormats;
import org.hipparchus.stat.interval.ConfidenceInterval;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class BinomialProportion {
    private static final NormalDistribution NORMAL_DISTRIBUTION = new NormalDistribution(0.0, 1.0);

    private BinomialProportion() {
    }

    public static ConfidenceInterval getAgrestiCoullInterval(int numberOfTrials, double probabilityOfSuccess, double confidenceLevel) throws MathIllegalArgumentException {
        BinomialProportion.checkParameters(numberOfTrials, probabilityOfSuccess, confidenceLevel);
        int numberOfSuccesses = (int)((double)numberOfTrials * probabilityOfSuccess);
        double alpha = (1.0 - confidenceLevel) / 2.0;
        double z = NORMAL_DISTRIBUTION.inverseCumulativeProbability(1.0 - alpha);
        double zSquared = FastMath.pow((double)z, (int)2);
        double modifiedNumberOfTrials = (double)numberOfTrials + zSquared;
        double modifiedSuccessesRatio = 1.0 / modifiedNumberOfTrials * ((double)numberOfSuccesses + 0.5 * zSquared);
        double difference = z * FastMath.sqrt((double)(1.0 / modifiedNumberOfTrials * modifiedSuccessesRatio * (1.0 - modifiedSuccessesRatio)));
        return new ConfidenceInterval(modifiedSuccessesRatio - difference, modifiedSuccessesRatio + difference, confidenceLevel);
    }

    public static ConfidenceInterval getClopperPearsonInterval(int numberOfTrials, double probabilityOfSuccess, double confidenceLevel) throws MathIllegalArgumentException {
        BinomialProportion.checkParameters(numberOfTrials, probabilityOfSuccess, confidenceLevel);
        double lowerBound = 0.0;
        double upperBound = 0.0;
        int numberOfSuccesses = (int)((double)numberOfTrials * probabilityOfSuccess);
        if (numberOfSuccesses > 0) {
            double alpha = (1.0 - confidenceLevel) / 2.0;
            FDistribution distributionLowerBound = new FDistribution((double)(2 * (numberOfTrials - numberOfSuccesses + 1)), (double)(2 * numberOfSuccesses));
            double fValueLowerBound = distributionLowerBound.inverseCumulativeProbability(1.0 - alpha);
            lowerBound = (double)numberOfSuccesses / ((double)numberOfSuccesses + (double)(numberOfTrials - numberOfSuccesses + 1) * fValueLowerBound);
            FDistribution distributionUpperBound = new FDistribution((double)(2 * (numberOfSuccesses + 1)), (double)(2 * (numberOfTrials - numberOfSuccesses)));
            double fValueUpperBound = distributionUpperBound.inverseCumulativeProbability(1.0 - alpha);
            upperBound = (double)(numberOfSuccesses + 1) * fValueUpperBound / ((double)(numberOfTrials - numberOfSuccesses) + (double)(numberOfSuccesses + 1) * fValueUpperBound);
        }
        return new ConfidenceInterval(lowerBound, upperBound, confidenceLevel);
    }

    public static ConfidenceInterval getNormalApproximationInterval(int numberOfTrials, double probabilityOfSuccess, double confidenceLevel) throws MathIllegalArgumentException {
        BinomialProportion.checkParameters(numberOfTrials, probabilityOfSuccess, confidenceLevel);
        double mean = probabilityOfSuccess;
        double alpha = (1.0 - confidenceLevel) / 2.0;
        double difference = NORMAL_DISTRIBUTION.inverseCumulativeProbability(1.0 - alpha) * FastMath.sqrt((double)(1.0 / (double)numberOfTrials * mean * (1.0 - mean)));
        return new ConfidenceInterval(mean - difference, mean + difference, confidenceLevel);
    }

    public static ConfidenceInterval getWilsonScoreInterval(int numberOfTrials, double probabilityOfSuccess, double confidenceLevel) throws MathIllegalArgumentException {
        BinomialProportion.checkParameters(numberOfTrials, probabilityOfSuccess, confidenceLevel);
        double alpha = (1.0 - confidenceLevel) / 2.0;
        double z = NORMAL_DISTRIBUTION.inverseCumulativeProbability(1.0 - alpha);
        double zSquared = FastMath.pow((double)z, (int)2);
        double mean = probabilityOfSuccess;
        double factor = 1.0 / (1.0 + 1.0 / (double)numberOfTrials * zSquared);
        double modifiedSuccessRatio = mean + 1.0 / (double)(2 * numberOfTrials) * zSquared;
        double difference = z * FastMath.sqrt((double)(1.0 / (double)numberOfTrials * mean * (1.0 - mean) + 1.0 / (4.0 * FastMath.pow((double)numberOfTrials, (int)2)) * zSquared));
        double lowerBound = factor * (modifiedSuccessRatio - difference);
        double upperBound = factor * (modifiedSuccessRatio + difference);
        return new ConfidenceInterval(lowerBound, upperBound, confidenceLevel);
    }

    private static void checkParameters(int numberOfTrials, double probabilityOfSuccess, double confidenceLevel) {
        if (numberOfTrials <= 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_OF_TRIALS, new Object[]{numberOfTrials});
        }
        MathUtils.checkRangeInclusive((double)probabilityOfSuccess, (double)0.0, (double)1.0);
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedStatFormats.OUT_OF_BOUNDS_CONFIDENCE_LEVEL, new Object[]{confidenceLevel, 0, 1});
        }
    }
}

