/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class LatitudeExtremumDetector
extends AbstractDetector<LatitudeExtremumDetector> {
    private static final long serialVersionUID = 20150824L;
    private OneAxisEllipsoid body;

    public LatitudeExtremumDetector(OneAxisEllipsoid body) {
        this(600.0, 1.0E-6, body);
    }

    public LatitudeExtremumDetector(double maxCheck, double threshold, OneAxisEllipsoid body) {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), body);
    }

    private LatitudeExtremumDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super LatitudeExtremumDetector> handler, OneAxisEllipsoid body) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
    }

    @Override
    protected LatitudeExtremumDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super LatitudeExtremumDetector> newHandler) {
        return new LatitudeExtremumDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body);
    }

    public BodyShape getBody() {
        return this.body;
    }

    @Override
    public double g(SpacecraftState s) {
        FieldGeodeticPoint<DerivativeStructure> gp = this.body.transform(s.getPVCoordinates(), s.getFrame(), s.getDate());
        return gp.getLatitude().getPartialDerivative(new int[]{1});
    }
}

