/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdamsIntegrator;
import org.hipparchus.ode.nonstiff.AdamsStateInterpolator;
import org.hipparchus.util.FastMath;

public class AdamsBashforthIntegrator
extends AdamsIntegrator {
    private static final String METHOD_NAME = "Adams-Bashforth";

    public AdamsBashforthIntegrator(int nSteps, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(METHOD_NAME, nSteps, nSteps, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public AdamsBashforthIntegrator(int nSteps, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super(METHOD_NAME, nSteps, nSteps, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    private double errorEstimation(double[] previousState, double[] predictedState, double[] predictedScaled, RealMatrix predictedNordsieck) {
        double error = 0.0;
        for (int i = 0; i < this.mainSetDimension; ++i) {
            double yScale = FastMath.abs((double)predictedState[i]);
            double tol = this.vecAbsoluteTolerance == null ? this.scalAbsoluteTolerance + this.scalRelativeTolerance * yScale : this.vecAbsoluteTolerance[i] + this.vecRelativeTolerance[i] * yScale;
            double variation = 0.0;
            int sign = predictedNordsieck.getRowDimension() % 2 == 0 ? -1 : 1;
            for (int k = predictedNordsieck.getRowDimension() - 1; k >= 0; --k) {
                variation += (double)sign * predictedNordsieck.getEntry(k, i);
                sign = -sign;
            }
            double ratio = (predictedState[i] - previousState[i] + (variation -= predictedScaled[i])) / tol;
            error += ratio * ratio;
        }
        return FastMath.sqrt((double)(error / (double)this.mainSetDimension));
    }

    @Override
    public ODEStateAndDerivative integrate(ExpandableODE equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = finalTime > initialState.getTime();
        this.start(equations, this.getStepStart(), finalTime);
        ODEStateAndDerivative stepEnd = AdamsStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), this.getStepStart().getTime() + this.getStepSize(), this.getStepSize(), this.scaled, this.nordsieck);
        this.setIsLastStep(false);
        double[] y = this.getStepStart().getCompleteState();
        do {
            double[] predictedY = null;
            double[] predictedScaled = new double[y.length];
            Array2DRowRealMatrix predictedNordsieck = null;
            double error = 10.0;
            while (error >= 1.0) {
                predictedY = stepEnd.getCompleteState();
                double[] yDot = this.computeDerivatives(stepEnd.getTime(), predictedY);
                for (int j = 0; j < predictedScaled.length; ++j) {
                    predictedScaled[j] = this.getStepSize() * yDot[j];
                }
                predictedNordsieck = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                this.updateHighOrderDerivativesPhase2(this.scaled, predictedScaled, predictedNordsieck);
                error = this.errorEstimation(y, predictedY, predictedScaled, (RealMatrix)predictedNordsieck);
                if (Double.isNaN(error)) {
                    throw new MathIllegalStateException((Localizable)LocalizedODEFormats.NAN_APPEARING_DURING_INTEGRATION, new Object[]{stepEnd.getTime()});
                }
                if (!(error >= 1.0)) continue;
                double factor = this.computeStepGrowShrinkFactor(error);
                this.rescale(this.filterStep(this.getStepSize() * factor, forward, false));
                stepEnd = AdamsStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), this.getStepStart().getTime() + this.getStepSize(), this.getStepSize(), this.scaled, this.nordsieck);
            }
            this.setStepStart(this.acceptStep(new AdamsStateInterpolator(this.getStepSize(), stepEnd, predictedScaled, predictedNordsieck, forward, this.getStepStart(), stepEnd, equations.getMapper()), finalTime));
            this.scaled = predictedScaled;
            this.nordsieck = predictedNordsieck;
            if (this.isLastStep()) continue;
            if (this.resetOccurred()) {
                this.start(equations, this.getStepStart(), finalTime);
                double nextT = this.getStepStart().getTime() + this.getStepSize();
                boolean nextIsLast = forward ? nextT >= finalTime : nextT <= finalTime;
                double hNew = nextIsLast ? finalTime - this.getStepStart().getTime() : this.getStepSize();
                this.rescale(hNew);
                System.arraycopy(this.getStepStart().getCompleteState(), 0, y, 0, y.length);
            } else {
                boolean filteredNextIsLast;
                double factor = this.computeStepGrowShrinkFactor(error);
                double scaledH = this.getStepSize() * factor;
                double nextT = this.getStepStart().getTime() + scaledH;
                boolean nextIsLast = forward ? nextT >= finalTime : nextT <= finalTime;
                double hNew = this.filterStep(scaledH, forward, nextIsLast);
                double filteredNextT = this.getStepStart().getTime() + hNew;
                boolean bl = forward ? filteredNextT >= finalTime : (filteredNextIsLast = filteredNextT <= finalTime);
                if (filteredNextIsLast) {
                    hNew = finalTime - this.getStepStart().getTime();
                }
                this.rescale(hNew);
                System.arraycopy(predictedY, 0, y, 0, y.length);
            }
            stepEnd = AdamsStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), this.getStepStart().getTime() + this.getStepSize(), this.getStepSize(), this.scaled, this.nordsieck);
        } while (!this.isLastStep());
        ODEStateAndDerivative finalState = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(Double.NaN);
        return finalState;
    }
}

