/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import org.hipparchus.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;

public class GPSDate
implements Serializable,
TimeStamped {
    private static final long serialVersionUID = 20180633L;
    private static final double WEEK = 604800.0;
    private static final double S_TO_MS = 1000.0;
    private final int weekNumber;
    private final double milliInWeek;
    private final transient AbsoluteDate date;

    public GPSDate(int weekNumber, double milliInWeek) {
        this.weekNumber = weekNumber;
        this.milliInWeek = milliInWeek;
        int day = (int)FastMath.floor((double)(milliInWeek / 8.64E7));
        double secondsInDay = milliInWeek / 1000.0 - (double)day * 86400.0;
        this.date = new AbsoluteDate(new DateComponents(DateComponents.GPS_EPOCH, weekNumber * 7 + day), new TimeComponents(secondsInDay), (TimeScale)TimeScalesFactory.getGPS());
    }

    public GPSDate(AbsoluteDate date) {
        this.weekNumber = (int)FastMath.floor((double)(date.durationFrom(AbsoluteDate.GPS_EPOCH) / 604800.0));
        AbsoluteDate weekStart = new AbsoluteDate(AbsoluteDate.GPS_EPOCH, 604800.0 * (double)this.weekNumber);
        this.milliInWeek = date.durationFrom(weekStart) * 1000.0;
        this.date = date;
    }

    public int getWeekNumber() {
        return this.weekNumber;
    }

    public double getMilliInWeek() {
        return this.milliInWeek;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    private Object writeReplace() {
        return new DataTransferObject(this.weekNumber, this.milliInWeek);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20180633L;
        private final int weekNumber;
        private final double milliInWeek;

        DataTransferObject(int weekNumber, double milliInWeek) {
            this.weekNumber = weekNumber;
            this.milliInWeek = milliInWeek;
        }

        private Object readResolve() {
            return new GPSDate(this.weekNumber, this.milliInWeek);
        }
    }
}

