/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.TurnAroundRange;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OnBoardAntennaTurnAroundRangeModifier
implements EstimationModifier<TurnAroundRange> {
    private final Vector3D antennaPhaseCenter;

    public OnBoardAntennaTurnAroundRangeModifier(Vector3D antennaPhaseCenter) {
        this.antennaPhaseCenter = antennaPhaseCenter;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<TurnAroundRange> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        Vector3D pMasterEmission = participants[0].getPosition();
        AbsoluteDate transitDateLeg1 = participants[1].getDate();
        Vector3D pSlaveRebound = participants[2].getPosition();
        AbsoluteDate transitDateLeg2 = participants[3].getDate();
        Vector3D pMasterReception = participants[4].getPosition();
        SpacecraftState refState = estimated.getStates()[0];
        SpacecraftState transitStateLeg1 = refState.shiftedBy(transitDateLeg1.durationFrom(refState.getDate()));
        Transform spacecraftToInertLeg1 = transitStateLeg1.toTransform().getInverse();
        SpacecraftState transitStateLeg2 = refState.shiftedBy(transitDateLeg2.durationFrom(refState.getDate()));
        Transform spacecraftToInertLeg2 = transitStateLeg2.toTransform().getInverse();
        Vector3D pSpacecraftLeg1 = spacecraftToInertLeg1.transformPosition(Vector3D.ZERO);
        Vector3D pSpacecraftLeg2 = spacecraftToInertLeg2.transformPosition(Vector3D.ZERO);
        double turnAroundRangeUsingSpacecraftCenter = 0.5 * (Vector3D.distance((Vector3D)pMasterEmission, (Vector3D)pSpacecraftLeg1) + Vector3D.distance((Vector3D)pSpacecraftLeg1, (Vector3D)pSlaveRebound) + Vector3D.distance((Vector3D)pSlaveRebound, (Vector3D)pSpacecraftLeg2) + Vector3D.distance((Vector3D)pSpacecraftLeg2, (Vector3D)pMasterReception));
        Vector3D pAPCLeg1 = spacecraftToInertLeg1.transformPosition(this.antennaPhaseCenter);
        Vector3D pAPCLeg2 = spacecraftToInertLeg2.transformPosition(this.antennaPhaseCenter);
        double turnAroundRangeUsingAntennaPhaseCenter = 0.5 * (Vector3D.distance((Vector3D)pMasterEmission, (Vector3D)pAPCLeg1) + Vector3D.distance((Vector3D)pAPCLeg1, (Vector3D)pSlaveRebound) + Vector3D.distance((Vector3D)pSlaveRebound, (Vector3D)pAPCLeg2) + Vector3D.distance((Vector3D)pAPCLeg2, (Vector3D)pMasterReception));
        double[] value = estimated.getEstimatedValue();
        value[0] = value[0] + (turnAroundRangeUsingAntennaPhaseCenter - turnAroundRangeUsingSpacecraftCenter);
        estimated.setEstimatedValue(value);
    }
}

