/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Position
extends AbstractMeasurement<Position> {
    private static final double[][] IDENTITY = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}};
    private final double[][] covarianceMatrix;

    @Deprecated
    public Position(AbsoluteDate date, Vector3D position, double sigmaPosition, double baseWeight) {
        this(date, position, sigmaPosition, baseWeight, new ObservableSatellite(0));
    }

    @Deprecated
    public Position(AbsoluteDate date, Vector3D position, double sigmaPosition, double baseWeight, int propagatorIndex) {
        this(date, position, sigmaPosition, baseWeight, new ObservableSatellite(propagatorIndex));
    }

    public Position(AbsoluteDate date, Vector3D position, double sigmaPosition, double baseWeight, ObservableSatellite satellite) {
        this(date, position, new double[]{sigmaPosition, sigmaPosition, sigmaPosition}, baseWeight, satellite);
    }

    @Deprecated
    public Position(AbsoluteDate date, Vector3D position, double[] sigmaPosition, double baseWeight) {
        this(date, position, sigmaPosition, baseWeight, new ObservableSatellite(0));
    }

    @Deprecated
    public Position(AbsoluteDate date, Vector3D position, double[] sigmaPosition, double baseWeight, int propagatorIndex) {
        this(date, position, sigmaPosition, baseWeight, new ObservableSatellite(propagatorIndex));
    }

    public Position(AbsoluteDate date, Vector3D position, double[] sigmaPosition, double baseWeight, ObservableSatellite satellite) {
        this(date, position, Position.buildPvCovarianceMatrix(sigmaPosition), baseWeight, satellite);
    }

    @Deprecated
    public Position(AbsoluteDate date, Vector3D position, double[][] positionCovarianceMatrix, double baseWeight) {
        this(date, position, positionCovarianceMatrix, baseWeight, new ObservableSatellite(0));
    }

    @Deprecated
    public Position(AbsoluteDate date, Vector3D position, double[][] covarianceMatrix, double baseWeight, int propagatorIndex) {
        this(date, position, covarianceMatrix, baseWeight, new ObservableSatellite(propagatorIndex));
    }

    public Position(AbsoluteDate date, Vector3D position, double[][] covarianceMatrix, double baseWeight, ObservableSatellite satellite) {
        super(date, new double[]{position.getX(), position.getY(), position.getZ()}, Position.extractSigmas(covarianceMatrix), new double[]{baseWeight, baseWeight, baseWeight}, Arrays.asList(satellite));
        this.covarianceMatrix = covarianceMatrix;
    }

    public Vector3D getPosition() {
        double[] pv = this.getObservedValue();
        return new Vector3D(pv[0], pv[1], pv[2]);
    }

    public double[][] getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public double[][] getCorrelationCoefficientsMatrix() {
        double[] sigmas = this.getTheoreticalStandardDeviation();
        double[][] corrCoefMatrix = new double[sigmas.length][sigmas.length];
        for (int i = 0; i < sigmas.length; ++i) {
            for (int j = 0; j < sigmas.length; ++j) {
                corrCoefMatrix[i][j] = this.covarianceMatrix[i][j] / (sigmas[i] * sigmas[j]);
            }
        }
        return corrCoefMatrix;
    }

    @Override
    protected EstimatedMeasurement<Position> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites().get(0);
        SpacecraftState state = states[satellite.getPropagatorIndex()];
        TimeStampedPVCoordinates pv = state.getPVCoordinates();
        EstimatedMeasurement<Position> estimated = new EstimatedMeasurement<Position>(this, iteration, evaluation, states, new TimeStampedPVCoordinates[]{pv});
        estimated.setEstimatedValue(pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ());
        estimated.setStateDerivatives(0, IDENTITY);
        return estimated;
    }

    private static double[] extractSigmas(double[][] pCovarianceMatrix) {
        if (pCovarianceMatrix.length != 3 || pCovarianceMatrix[0].length != 3) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, pCovarianceMatrix.length, pCovarianceMatrix[0], 3, 3);
        }
        double[] sigmas = new double[3];
        for (int i = 0; i < sigmas.length; ++i) {
            sigmas[i] = FastMath.sqrt((double)pCovarianceMatrix[i][i]);
        }
        return sigmas;
    }

    private static double[][] buildPvCovarianceMatrix(double[] sigmaP) {
        if (sigmaP.length != 3) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, sigmaP.length, 3);
        }
        double[][] pvCovarianceMatrix = new double[3][3];
        for (int i = 0; i < sigmaP.length; ++i) {
            pvCovarianceMatrix[i][i] = sigmaP[i] * sigmaP[i];
        }
        return pvCovarianceMatrix;
    }
}

