/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.models.earth.tessellation.Mesh;

enum Direction {
    PLUS_ALONG{

        @Override
        public Direction next() {
            return PLUS_ACROSS;
        }

        @Override
        public int neighborAlongIndex(Mesh.Node base) {
            return base.getAlongIndex() + 1;
        }

        @Override
        public Vector3D motion(Mesh.Node base, double alongDistance, double acrossDistance) {
            return new Vector3D(alongDistance, base.getAlong());
        }
    }
    ,
    MINUS_ALONG{

        @Override
        public Direction next() {
            return MINUS_ACROSS;
        }

        @Override
        public int neighborAlongIndex(Mesh.Node base) {
            return base.getAlongIndex() - 1;
        }

        @Override
        public Vector3D motion(Mesh.Node base, double alongDistance, double acrossDistance) {
            return new Vector3D(-alongDistance, base.getAlong());
        }
    }
    ,
    PLUS_ACROSS{

        @Override
        public Direction next() {
            return MINUS_ALONG;
        }

        @Override
        public int neighborAcrossIndex(Mesh.Node base) {
            return base.getAcrossIndex() + 1;
        }

        @Override
        public Vector3D motion(Mesh.Node base, double alongDistance, double acrossDistance) {
            return new Vector3D(acrossDistance, base.getAcross());
        }
    }
    ,
    MINUS_ACROSS{

        @Override
        public Direction next() {
            return PLUS_ALONG;
        }

        @Override
        public int neighborAcrossIndex(Mesh.Node base) {
            return base.getAcrossIndex() - 1;
        }

        @Override
        public Vector3D motion(Mesh.Node base, double alongDistance, double acrossDistance) {
            return new Vector3D(-acrossDistance, base.getAcross());
        }
    };


    public abstract Direction next();

    public int neighborAlongIndex(Mesh.Node base) {
        return base.getAlongIndex();
    }

    public int neighborAcrossIndex(Mesh.Node base) {
        return base.getAcrossIndex();
    }

    public abstract Vector3D motion(Mesh.Node var1, double var2, double var4);
}

