/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.models.earth.DiscreteTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.ParameterDriver;

public class ViennaOneModel
implements DiscreteTroposphericModel {
    private static final long serialVersionUID = 2584920506094034855L;
    private final double[] coefficientsA;
    private final double[] zenithDelay;
    private final double latitude;

    public ViennaOneModel(double[] coefficientA, double[] zenithDelay, double latitude) {
        this.coefficientsA = (double[])coefficientA.clone();
        this.zenithDelay = (double[])zenithDelay.clone();
        this.latitude = latitude;
    }

    @Override
    public double pathDelay(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double[] delays = this.computeZenithDelay(height, parameters, date);
        double[] mappingFunction = this.mappingFactors(elevation, height, parameters, date);
        return delays[0] * mappingFunction[0] + delays[1] * mappingFunction[1];
    }

    @Override
    public <T extends RealFieldElement<T>> T pathDelay(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement[] delays = this.computeZenithDelay((RealFieldElement)height, (RealFieldElement[])parameters, date);
        RealFieldElement[] mappingFunction = this.mappingFactors((RealFieldElement)elevation, (RealFieldElement)height, (RealFieldElement[])parameters, date);
        return (T)((RealFieldElement)((RealFieldElement)delays[0].multiply((Object)mappingFunction[0])).add(delays[1].multiply((Object)mappingFunction[1])));
    }

    @Override
    public double[] computeZenithDelay(double height, double[] parameters, AbsoluteDate date) {
        return this.zenithDelay;
    }

    @Override
    public <T extends RealFieldElement<T>> T[] computeZenithDelay(T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field field = height.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement[] delays = (RealFieldElement[])MathArrays.buildArray((Field)field, (int)2);
        delays[0] = (RealFieldElement)zero.add(this.zenithDelay[0]);
        delays[1] = (RealFieldElement)zero.add(this.zenithDelay[1]);
        return delays;
    }

    @Override
    public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double psi;
        double c11h;
        double c10h;
        DateTimeComponents dtc = date.getComponents(TimeScalesFactory.getUTC());
        int dofyear = dtc.getDate().getDayOfYear();
        double bh = 0.0029;
        double c0h = 0.062;
        if (FastMath.sin((double)this.latitude) > 0.0) {
            c10h = 0.001;
            c11h = 0.005;
            psi = 0.0;
        } else {
            c10h = 0.002;
            c11h = 0.007;
            psi = Math.PI;
        }
        double t0 = 28.0;
        if (this.latitude < 0.0) {
            t0 += 183.0;
        }
        double coef = ((double)dofyear - t0) / 365.0 * 2.0 * Math.PI + psi;
        double ch = 0.062 + ((FastMath.cos((double)coef) + 1.0) * (c11h / 2.0) + c10h) * (1.0 - FastMath.cos((double)this.latitude));
        double bw = 0.00146;
        double cw = 0.04391;
        double[] function = new double[]{this.computeFunction(this.coefficientsA[0], 0.0029, ch, elevation), this.computeFunction(this.coefficientsA[1], 0.00146, 0.04391, elevation)};
        double correction = this.computeHeightCorrection(elevation, height);
        function[0] = function[0] + correction;
        return function;
    }

    @Override
    public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement psi;
        RealFieldElement c11h;
        RealFieldElement c10h;
        Field<T> field = date.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        DateTimeComponents dtc = date.getComponents(TimeScalesFactory.getUTC());
        int dofyear = dtc.getDate().getDayOfYear();
        RealFieldElement bh = (RealFieldElement)zero.add(0.0029);
        RealFieldElement c0h = (RealFieldElement)zero.add(0.062);
        if (FastMath.sin((double)this.latitude) > 0.0) {
            c10h = (RealFieldElement)zero.add(0.001);
            c11h = (RealFieldElement)zero.add(0.005);
            psi = zero;
        } else {
            c10h = (RealFieldElement)zero.add(0.002);
            c11h = (RealFieldElement)zero.add(0.007);
            psi = (RealFieldElement)zero.add(Math.PI);
        }
        double t0 = 28.0;
        if (this.latitude < 0.0) {
            t0 += 183.0;
        }
        RealFieldElement coef = (RealFieldElement)psi.add(((double)dofyear - t0) / 365.0 * 2.0 * Math.PI);
        RealFieldElement ch = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c11h.divide(2.0)).multiply(FastMath.cos((RealFieldElement)coef).add(1.0))).add((Object)c10h)).multiply(1.0 - FastMath.cos((double)this.latitude))).add((Object)c0h);
        RealFieldElement bw = (RealFieldElement)zero.add(0.00146);
        RealFieldElement cw = (RealFieldElement)zero.add(0.04391);
        RealFieldElement[] function = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        function[0] = this.computeFunction((RealFieldElement)zero.add(this.coefficientsA[0]), bh, ch, elevation);
        function[1] = this.computeFunction((RealFieldElement)zero.add(this.coefficientsA[1]), bw, cw, elevation);
        T correction = this.computeHeightCorrection(elevation, height, field);
        function[0] = (RealFieldElement)function[0].add(correction);
        return function;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double computeFunction(double a, double b, double c, double elevation) {
        double sinE = FastMath.sin((double)elevation);
        double numMP = 1.0 + a / (1.0 + b / (1.0 + c));
        double denMP = sinE + a / (sinE + b / (sinE + c));
        double felevation = numMP / denMP;
        return felevation;
    }

    private <T extends RealFieldElement<T>> T computeFunction(T a, T b, T c, T elevation) {
        RealFieldElement sinE = FastMath.sin(elevation);
        RealFieldElement numMP = (RealFieldElement)((RealFieldElement)a.divide(((RealFieldElement)b.divide(c.add(1.0))).add(1.0))).add(1.0);
        RealFieldElement denMP = (RealFieldElement)((RealFieldElement)a.divide(((RealFieldElement)b.divide(c.add((Object)sinE))).add((Object)sinE))).add((Object)sinE);
        RealFieldElement felevation = (RealFieldElement)numMP.divide((Object)denMP);
        return (T)felevation;
    }

    private double computeHeightCorrection(double elevation, double height) {
        double fixedHeight = FastMath.max((double)0.0, (double)height);
        double sinE = FastMath.sin((double)elevation);
        double function = this.computeFunction(2.53E-5, 0.00549, 0.00114, elevation);
        double dmdh = 1.0 / sinE - function;
        double correction = dmdh * (fixedHeight / 1000.0);
        return correction;
    }

    private <T extends RealFieldElement<T>> T computeHeightCorrection(T elevation, T height, Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement fixedHeight = FastMath.max((RealFieldElement)zero, height);
        RealFieldElement sinE = FastMath.sin(elevation);
        RealFieldElement function = this.computeFunction((RealFieldElement)zero.add(2.53E-5), (RealFieldElement)zero.add(0.00549), (RealFieldElement)zero.add(0.00114), elevation);
        RealFieldElement dmdh = (RealFieldElement)((RealFieldElement)sinE.reciprocal()).subtract((Object)function);
        RealFieldElement correction = (RealFieldElement)dmdh.multiply(fixedHeight.divide(1000.0));
        return (T)correction;
    }
}

