/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;

public class InertialProvider
implements AttitudeProvider {
    public static final InertialProvider EME2000_ALIGNED = new InertialProvider(Rotation.IDENTITY);
    private static final long serialVersionUID = -818658655669855332L;
    private final Frame satelliteFrame;

    public InertialProvider(Rotation rotation) {
        this.satelliteFrame = new Frame((Frame)FramesFactory.getEME2000(), new Transform(AbsoluteDate.J2000_EPOCH, rotation), null, false);
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Transform t = frame.getTransformTo(this.satelliteFrame, date);
        return new Attitude(date, frame, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldTransform<T> t = frame.getTransformTo(this.satelliteFrame, date);
        return new FieldAttitude<T>(date, frame, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }
}

