/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.spherical.twod.Edge;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.geometry.spherical.twod.Vertex;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.Transform;
import org.orekit.models.earth.tessellation.ConstantAzimuthAiming;
import org.orekit.models.earth.tessellation.EllipsoidTessellator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.FieldOfView;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.SphericalPolygonsSetTransferObject;

public class FootprintOverlapDetector
extends AbstractDetector<FootprintOverlapDetector> {
    private static final long serialVersionUID = 20150112L;
    private final transient FieldOfView fov;
    private final OneAxisEllipsoid body;
    private final transient SphericalPolygonsSet zone;
    private final double samplingStep;
    private final transient List<SamplingPoint> sampledZone;
    private final transient Vector3D capCenter;
    private final transient double capCos;
    private final transient double capSin;

    public FootprintOverlapDetector(FieldOfView fov, OneAxisEllipsoid body, SphericalPolygonsSet zone, double samplingStep) throws OrekitException {
        this(600.0, 1.0E-6, 100, new StopOnIncreasing(), fov, body, zone, samplingStep, FootprintOverlapDetector.sample(body, zone, samplingStep));
    }

    private FootprintOverlapDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super FootprintOverlapDetector> handler, FieldOfView fov, OneAxisEllipsoid body, SphericalPolygonsSet zone, double samplingStep, List<SamplingPoint> sampledZone) {
        super(maxCheck, threshold, maxIter, handler);
        this.fov = fov;
        this.body = body;
        this.samplingStep = samplingStep;
        this.zone = zone;
        this.sampledZone = sampledZone;
        EnclosingBall cap = zone.getEnclosingCap();
        this.capCenter = ((S2Point)cap.getCenter()).getVector();
        this.capCos = FastMath.cos((double)cap.getRadius());
        this.capSin = FastMath.sin((double)cap.getRadius());
    }

    private static List<SamplingPoint> sample(OneAxisEllipsoid body, SphericalPolygonsSet zone, double samplingStep) throws OrekitException {
        ArrayList<SamplingPoint> sampledZone = new ArrayList<SamplingPoint>();
        List boundary = zone.getBoundaryLoops();
        for (Vertex loopStart : boundary) {
            int count = 0;
            Vertex v = loopStart;
            while (count == 0 || v != loopStart) {
                ++count;
                Edge edge = v.getOutgoing();
                int n = (int)FastMath.ceil((double)(edge.getLength() * body.getEquatorialRadius() / samplingStep));
                for (int i = 0; i < n; ++i) {
                    S2Point intermediate = new S2Point(edge.getPointAt((double)i * edge.getLength() / (double)n));
                    GeodeticPoint gp = new GeodeticPoint(1.5707963267948966 - intermediate.getPhi(), intermediate.getTheta(), 0.0);
                    sampledZone.add(new SamplingPoint(body.transform(gp), gp.getZenith()));
                }
                v = v.getOutgoing().getEnd();
            }
        }
        EllipsoidTessellator tessellator = new EllipsoidTessellator(body, new ConstantAzimuthAiming(body, 0.0), 4);
        List<List<GeodeticPoint>> gpSample = tessellator.sample(zone, samplingStep, samplingStep);
        for (List<GeodeticPoint> list : gpSample) {
            for (GeodeticPoint gp : list) {
                sampledZone.add(new SamplingPoint(body.transform(gp), gp.getZenith()));
            }
        }
        return sampledZone;
    }

    @Override
    protected FootprintOverlapDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super FootprintOverlapDetector> newHandler) {
        return new FootprintOverlapDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.fov, this.body, this.zone, this.samplingStep, this.sampledZone);
    }

    public SphericalPolygonsSet getZone() {
        return this.zone;
    }

    public FieldOfView getFieldOfView() {
        return this.fov;
    }

    public BodyShape getBody() {
        return this.body;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        Vector3D t;
        Vector3D close;
        double value = Math.PI;
        Vector3D scBody = s.getPVCoordinates(this.body.getBodyFrame()).getPosition();
        GeodeticPoint gp = this.body.transform(scBody, this.body.getBodyFrame(), s.getDate());
        S2Point s2p = new S2Point(gp.getLongitude(), 1.5707963267948966 - gp.getLatitude());
        Vector3D p = s2p.getVector();
        double dot = Vector3D.dotProduct((Vector3D)p, (Vector3D)this.capCenter);
        if (dot < this.capCos && Vector3D.dotProduct((Vector3D)p, (Vector3D)(close = new Vector3D(this.capCos, this.capCenter, this.capSin, t = p.subtract(dot, (Vector)this.capCenter).normalize()))) < -0.01) {
            return value;
        }
        Transform bodyToSc = new Transform(s.getDate(), this.body.getBodyFrame().getTransformTo(s.getFrame(), s.getDate()), s.toTransform());
        for (SamplingPoint point : this.sampledZone) {
            Vector3D lineOfSightBody = point.getPosition().subtract((Vector)scBody);
            if (!(Vector3D.dotProduct((Vector3D)lineOfSightBody, (Vector3D)point.getZenith()) <= 0.0)) continue;
            double offset = this.fov.offsetFromBoundary(bodyToSc.transformVector(lineOfSightBody));
            value = FastMath.min((double)value, (double)offset);
        }
        return value;
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class SamplingPoint {
        private final Vector3D position;
        private final Vector3D zenith;

        SamplingPoint(Vector3D position, Vector3D zenith) {
            this.position = position;
            this.zenith = zenith;
        }

        public Vector3D getPosition() {
            return this.position;
        }

        public Vector3D getZenith() {
            return this.zenith;
        }
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20150112L;
        private final double maxCheck;
        private final double threshold;
        private final int maxIter;
        private final OneAxisEllipsoid body;
        private final FieldOfView fov;
        private final SphericalPolygonsSetTransferObject zone;
        private final double samplingStep;

        private DTO(FootprintOverlapDetector detector) {
            this.maxCheck = detector.getMaxCheckInterval();
            this.threshold = detector.getThreshold();
            this.maxIter = detector.getMaxIterationCount();
            this.fov = detector.fov;
            this.body = detector.body;
            this.zone = new SphericalPolygonsSetTransferObject(detector.zone);
            this.samplingStep = detector.samplingStep;
        }

        private Object readResolve() {
            try {
                return ((FootprintOverlapDetector)((FootprintOverlapDetector)new FootprintOverlapDetector(this.fov, this.body, this.zone.rebuildZone(), this.samplingStep).withMaxCheck(this.maxCheck)).withThreshold(this.threshold)).withMaxIter(this.maxIter);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

