/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class Galileo
extends AbstractGNSSAttitudeProvider {
    private static final long serialVersionUID = 20171114L;
    private static final double BETA_X = FastMath.toRadians((double)15.0);
    private static final double BETA_Y = FastMath.toRadians((double)2.0);
    private static final double COS_NOON = FastMath.cos((double)BETA_X);
    private static final double COS_NIGHT = -COS_NOON;
    private final double END_MARGIN = 0.0;

    public Galileo(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        if (FastMath.abs((double)context.getBeta()) < BETA_Y && context.setUpTurnRegion(COS_NIGHT, COS_NOON)) {
            context.setHalfSpan(context.inSunSide() ? BETA_X : context.inOrbitPlaneAbsoluteAngle(BETA_X));
            if (context.inTurnTimeRange(context.getDate(), 0.0)) {
                DerivativeStructure beta = context.getBetaDS();
                DerivativeStructure cosBeta = beta.cos();
                DerivativeStructure sinBeta = beta.sin();
                double sinY = FastMath.copySign((double)FastMath.sin((double)BETA_Y), (double)context.getSecuredBeta());
                DerivativeStructure sd = ((DerivativeStructure)FastMath.sin((RealFieldElement)context.getDeltaDS())).multiply(FastMath.copySign((double)1.0, (double)(-context.getSVBcos() * context.getDeltaDS().getPartialDerivative(new int[]{1}))));
                DerivativeStructure c = sd.multiply(cosBeta);
                DerivativeStructure shy = sinBeta.negate().subtract(sinY).add(sinBeta.subtract(sinY).multiply(c.abs().multiply(Math.PI / FastMath.sin((double)BETA_X)).cos())).multiply(0.5);
                DerivativeStructure phi = (DerivativeStructure)FastMath.atan2((RealFieldElement)shy, (RealFieldElement)c);
                return context.turnCorrectedAttitude(phi);
            }
        }
        return context.getNominalYaw();
    }

    @Override
    protected <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        if (FastMath.abs(context.getBeta()).getReal() < BETA_Y && context.setUpTurnRegion(COS_NIGHT, COS_NOON)) {
            Field<T> field = context.getDate().getField();
            RealFieldElement betaX = (RealFieldElement)((RealFieldElement)field.getZero()).add(BETA_X);
            context.setHalfSpan(context.inSunSide() ? betaX : context.inOrbitPlaneAbsoluteAngle(betaX));
            if (context.inTurnTimeRange(context.getDate(), 0.0)) {
                FieldDerivativeStructure<T> beta = context.getBetaDS();
                FieldDerivativeStructure cosBeta = beta.cos();
                FieldDerivativeStructure sinBeta = beta.sin();
                RealFieldElement sinY = (RealFieldElement)FastMath.sin((RealFieldElement)((RealFieldElement)((RealFieldElement)field.getZero()).add(BETA_Y))).copySign(context.getSecuredBeta());
                FieldDerivativeStructure sd = ((FieldDerivativeStructure)FastMath.sin(context.getDeltaDS())).multiply(FastMath.copySign((double)1.0, (double)(-context.getSVBcos().getReal() * context.getDeltaDS().getPartialDerivative(new int[]{1}).getReal())));
                FieldDerivativeStructure c = sd.multiply(cosBeta);
                FieldDerivativeStructure shy = sinBeta.negate().subtract(sinY).add(sinBeta.subtract(sinY).multiply(c.abs().multiply(Math.PI / FastMath.sin((double)BETA_X)).cos())).multiply(0.5);
                FieldDerivativeStructure phi = (FieldDerivativeStructure)FastMath.atan2((RealFieldElement)shy, (RealFieldElement)c);
                return context.turnCorrectedAttitude(phi);
            }
        }
        return context.getNominalYaw();
    }
}

