/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.RealFieldElement;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractGNSSAttitudeProvider
implements GNSSAttitudeProvider {
    private static final long serialVersionUID = 20171114L;
    private final AbsoluteDate validityStart;
    private final AbsoluteDate validityEnd;
    private final ExtendedPVCoordinatesProvider sun;
    private final Frame inertialFrame;

    protected AbstractGNSSAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        this.validityStart = validityStart;
        this.validityEnd = validityEnd;
        this.sun = sun;
        this.inertialFrame = inertialFrame;
    }

    @Override
    public AbsoluteDate validityStart() {
        return this.validityStart;
    }

    @Override
    public AbsoluteDate validityEnd() {
        return this.validityEnd;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        TimeStampedPVCoordinates sunPV = this.sun.getPVCoordinates(date, this.inertialFrame);
        TimeStampedPVCoordinates svPV = pvProv.getPVCoordinates(date, this.inertialFrame);
        TimeStampedAngularCoordinates corrected = this.correctedYaw(new GNSSAttitudeContext(sunPV, svPV));
        return new Attitude(this.inertialFrame, corrected).withReferenceFrame(frame);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) throws OrekitException {
        TimeStampedFieldPVCoordinates<T> sunPV = this.sun.getPVCoordinates(date, this.inertialFrame);
        TimeStampedFieldPVCoordinates<T> svPV = pvProv.getPVCoordinates(date, this.inertialFrame);
        TimeStampedFieldAngularCoordinates<T> corrected = this.correctedYaw(new GNSSFieldAttitudeContext<T>(sunPV, svPV));
        return new FieldAttitude<T>(this.inertialFrame, corrected).withReferenceFrame(frame);
    }

    protected abstract TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext var1) throws OrekitException;

    protected abstract <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> var1) throws OrekitException;
}

