/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.FieldTransformGenerator;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformGenerator;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.GenericTimeStampedCache;

public class InterpolatingTransformProvider
implements TransformProvider {
    private static final long serialVersionUID = 20140723L;
    private final TransformProvider rawProvider;
    private final CartesianDerivativesFilter cFilter;
    private final AngularDerivativesFilter aFilter;
    private final double step;
    private final transient GenericTimeStampedCache<Transform> cache;
    private final transient Map<Field<? extends RealFieldElement<?>>, Object> fieldCaches;

    public InterpolatingTransformProvider(TransformProvider rawProvider, CartesianDerivativesFilter cFilter, AngularDerivativesFilter aFilter, int gridPoints, double step, int maxSlots, double maxSpan, double newSlotInterval) {
        this.rawProvider = rawProvider;
        this.cFilter = cFilter;
        this.aFilter = aFilter;
        this.step = step;
        this.cache = new GenericTimeStampedCache<Transform>(gridPoints, maxSlots, maxSpan, newSlotInterval, new TransformGenerator(gridPoints, rawProvider, step));
        this.fieldCaches = new HashMap();
    }

    @Deprecated
    public InterpolatingTransformProvider(TransformProvider rawProvider, CartesianDerivativesFilter cFilter, AngularDerivativesFilter aFilter, AbsoluteDate earliest, AbsoluteDate latest, int gridPoints, double step, int maxSlots, double maxSpan, double newSlotInterval) {
        this(rawProvider, cFilter, aFilter, gridPoints, step, maxSlots, maxSpan, newSlotInterval);
    }

    public TransformProvider getRawProvider() {
        return this.rawProvider;
    }

    public int getGridPoints() {
        return this.cache.getNeighborsSize();
    }

    public double getStep() {
        return this.step;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) throws OrekitException {
        try {
            List<Transform> sample = this.cache.getNeighbors(date).collect(Collectors.toList());
            return Transform.interpolate(date, this.cFilter, this.aFilter, sample);
        }
        catch (OrekitExceptionWrapper oew) {
            throw oew.getException();
        }
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) throws OrekitException {
        try {
            GenericTimeStampedCache<T> fieldCache = (GenericTimeStampedCache<T>)this.fieldCaches.get(date.getField());
            if (fieldCache == null) {
                fieldCache = new GenericTimeStampedCache<T>(this.cache.getNeighborsSize(), this.cache.getMaxSlots(), this.cache.getMaxSpan(), this.cache.getNewSlotQuantumGap(), new FieldTransformGenerator<T>(date.getField(), this.cache.getNeighborsSize(), this.rawProvider, this.step));
                this.fieldCaches.put(date.getField(), fieldCache);
            }
            Stream sample = fieldCache.getNeighbors(date.toAbsoluteDate());
            return FieldTransform.interpolate(date, this.cFilter, this.aFilter, sample);
        }
        catch (OrekitExceptionWrapper oew) {
            throw oew.getException();
        }
    }

    private Object writeReplace() {
        return new DTO(this.rawProvider, this.cFilter.getMaxOrder(), this.aFilter.getMaxOrder(), this.cache.getNeighborsSize(), this.step, this.cache.getMaxSlots(), this.cache.getMaxSpan(), this.cache.getNewSlotQuantumGap());
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20170823L;
        private final TransformProvider rawProvider;
        private final int cDerivatives;
        private final int aDerivatives;
        private final int gridPoints;
        private final double step;
        private final int maxSlots;
        private final double maxSpan;
        private final double newSlotInterval;

        private DTO(TransformProvider rawProvider, int cDerivatives, int aDerivatives, int gridPoints, double step, int maxSlots, double maxSpan, double newSlotInterval) {
            this.rawProvider = rawProvider;
            this.cDerivatives = cDerivatives;
            this.aDerivatives = aDerivatives;
            this.gridPoints = gridPoints;
            this.step = step;
            this.maxSlots = maxSlots;
            this.maxSpan = maxSpan;
            this.newSlotInterval = newSlotInterval;
        }

        private Object readResolve() {
            return new InterpolatingTransformProvider(this.rawProvider, CartesianDerivativesFilter.getFilter(this.cDerivatives), AngularDerivativesFilter.getFilter(this.aDerivatives), this.gridPoints, this.step, this.maxSlots, this.maxSpan, this.newSlotInterval);
        }
    }
}

