/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;

public abstract class StateMapper {
    private final AbsoluteDate referenceDate;
    private final OrbitType orbitType;
    private final PositionAngle angleType;
    private final AttitudeProvider attitudeProvider;
    private final double mu;
    private final Frame frame;

    protected StateMapper(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        this.referenceDate = referenceDate;
        this.mu = mu;
        this.orbitType = orbitType;
        this.angleType = positionAngleType;
        this.attitudeProvider = attitudeProvider;
        this.frame = frame;
    }

    public AbsoluteDate getReferenceDate() {
        return this.referenceDate;
    }

    public OrbitType getOrbitType() {
        return this.orbitType;
    }

    public void setPositionAngleType() {
    }

    public PositionAngle getPositionAngleType() {
        return this.angleType;
    }

    public double getMu() {
        return this.mu;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public AttitudeProvider getAttitudeProvider() {
        return this.attitudeProvider;
    }

    public AbsoluteDate mapDoubleToDate(double t) {
        return this.referenceDate.shiftedBy(t);
    }

    public AbsoluteDate mapDoubleToDate(double t, AbsoluteDate date) {
        if (date.durationFrom(this.referenceDate) == t) {
            return date;
        }
        return this.mapDoubleToDate(t);
    }

    public double mapDateToDouble(AbsoluteDate date) {
        return date.durationFrom(this.referenceDate);
    }

    public SpacecraftState mapArrayToState(double t, double[] y, double[] yDot, boolean meanOnly) throws OrekitException {
        return this.mapArrayToState(this.mapDoubleToDate(t), y, yDot, meanOnly);
    }

    public abstract SpacecraftState mapArrayToState(AbsoluteDate var1, double[] var2, double[] var3, boolean var4) throws OrekitException;

    public abstract void mapStateToArray(SpacecraftState var1, double[] var2, double[] var3) throws OrekitException;
}

