/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;

public class SphericalPolygonsSetTransferObject
implements Serializable {
    private static final long serialVersionUID = 20150112L;
    private final double tolerance;
    private final double[] cuts;
    private final int[] leafs;
    private final boolean[] flags;
    private transient int internalNodes;
    private transient int leafNodes;
    private transient int nodeIndex;
    private transient int cutIndex;
    private transient int flagIndex;

    public SphericalPolygonsSetTransferObject(SphericalPolygonsSet zone) {
        this.tolerance = zone.getTolerance();
        this.internalNodes = 0;
        this.leafNodes = 0;
        zone.getTree(false).visit((BSPTreeVisitor)new BSPTreeVisitor<Sphere2D>(){

            public BSPTreeVisitor.Order visitOrder(BSPTree<Sphere2D> node) {
                return BSPTreeVisitor.Order.SUB_MINUS_PLUS;
            }

            public void visitInternalNode(BSPTree<Sphere2D> node) {
                ++SphericalPolygonsSetTransferObject.this.internalNodes;
            }

            public void visitLeafNode(BSPTree<Sphere2D> node) {
                ++SphericalPolygonsSetTransferObject.this.leafNodes;
            }
        });
        this.cuts = new double[3 * this.internalNodes];
        this.leafs = new int[this.leafNodes];
        this.flags = new boolean[this.leafNodes];
        this.nodeIndex = 0;
        this.cutIndex = 0;
        this.flagIndex = 0;
        zone.getTree(false).visit((BSPTreeVisitor)new BSPTreeVisitor<Sphere2D>(){

            public BSPTreeVisitor.Order visitOrder(BSPTree<Sphere2D> node) {
                return BSPTreeVisitor.Order.SUB_MINUS_PLUS;
            }

            public void visitInternalNode(BSPTree<Sphere2D> node) {
                Vector3D cutPole = ((Circle)node.getCut().getHyperplane()).getPole();
                ((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).cuts[((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).cutIndex++] = cutPole.getX();
                ((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).cuts[((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).cutIndex++] = cutPole.getY();
                ((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).cuts[((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).cutIndex++] = cutPole.getZ();
                SphericalPolygonsSetTransferObject.this.nodeIndex++;
            }

            public void visitLeafNode(BSPTree<Sphere2D> node) {
                ((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).leafs[((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).flagIndex] = SphericalPolygonsSetTransferObject.this.nodeIndex++;
                ((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).flags[((SphericalPolygonsSetTransferObject)SphericalPolygonsSetTransferObject.this).flagIndex++] = (Boolean)node.getAttribute();
            }
        });
    }

    public SphericalPolygonsSet rebuildZone() {
        BSPTree node = new BSPTree();
        int nbNodes = this.cuts.length / 3 + this.leafs.length;
        this.cutIndex = 0;
        this.flagIndex = 0;
        this.nodeIndex = 0;
        while (this.nodeIndex < nbNodes) {
            if (this.leafs[this.flagIndex] == this.nodeIndex) {
                node.setAttribute((Object)this.flags[this.flagIndex++]);
                while (node.getParent() != null) {
                    BSPTree parent = node.getParent();
                    if (node == parent.getMinus()) {
                        node = parent.getPlus();
                        break;
                    }
                    node = parent;
                }
            } else {
                double x = this.cuts[this.cutIndex++];
                double y = this.cuts[this.cutIndex++];
                double z = this.cuts[this.cutIndex++];
                node.insertCut((Hyperplane)new Circle(new Vector3D(x, y, z), this.tolerance));
                node = node.getMinus();
            }
            ++this.nodeIndex;
        }
        return new SphericalPolygonsSet(node, this.tolerance);
    }
}

