/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.IonosphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeScalesFactory;

public class KlobucharIonoModel
implements IonosphericModel {
    private static final long serialVersionUID = 7277525837842061107L;
    private final double[] alpha;
    private final double[] beta;
    private final double ratio;

    public KlobucharIonoModel(double[] alpha, double[] beta) {
        this.alpha = (double[])alpha.clone();
        this.beta = (double[])beta.clone();
        this.ratio = 1.0;
    }

    public KlobucharIonoModel(double[] alpha, double[] beta, double frequency) {
        this.alpha = (double[])alpha.clone();
        this.beta = (double[])beta.clone();
        this.ratio = FastMath.pow((double)(1575.42 / frequency), (int)2);
    }

    @Override
    public double pathDelay(AbsoluteDate date, GeodeticPoint geo, double elevation, double azimuth) {
        double rad2semi = 0.3183098861837907;
        double semi2rad = Math.PI;
        double psi = 0.0137 / (elevation / Math.PI + 0.11) - 0.022;
        double latIono = FastMath.min((double)FastMath.max((double)(geo.getLatitude() * 0.3183098861837907 + psi * FastMath.cos((double)azimuth)), (double)-0.416), (double)0.416);
        double lonIono = geo.getLongitude() * 0.3183098861837907 + psi * FastMath.sin((double)azimuth) / FastMath.cos((double)(latIono * Math.PI));
        double latGeom = latIono + 0.064 * FastMath.cos((double)((lonIono - 1.617) * Math.PI));
        DateTimeComponents dtc = date.getComponents(TimeScalesFactory.getGPS());
        int dofweek = dtc.getDate().getDayOfWeek();
        double secday = dtc.getTime().getSecondsInLocalDay();
        double tow = (double)dofweek * 86400.0 + secday;
        double t = 43200.0 * lonIono + tow;
        double tsec = t - FastMath.floor((double)(t / 86400.0)) * 86400.0;
        double slantFactor = 1.0 + 16.0 * FastMath.pow((double)(0.53 - elevation / Math.PI), (int)3);
        double period = FastMath.max((double)72000.0, (double)(this.beta[0] + (this.beta[1] + (this.beta[2] + this.beta[3] * latGeom) * latGeom) * latGeom));
        double x = Math.PI * 2 * (tsec - 50400.0) / period;
        double amplitude = FastMath.max((double)0.0, (double)(this.alpha[0] + (this.alpha[1] + (this.alpha[2] + this.alpha[3] * latGeom) * latGeom) * latGeom));
        double ionoTimeDelayL1 = slantFactor * 5.0E-9;
        if (FastMath.abs((double)x) < 1.57) {
            ionoTimeDelayL1 += slantFactor * (amplitude * (1.0 - FastMath.pow((double)x, (int)2) / 2.0 + FastMath.pow((double)x, (int)4) / 24.0));
        }
        return this.ratio * 2.99792458E8 * ionoTimeDelayL1;
    }
}

