/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.models.earth.TroposphericModel;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;
import org.orekit.utils.StateFunction;

public class RangeRateTroposphericDelayModifier
implements EstimationModifier<RangeRate> {
    private final TroposphericModel tropoModel;
    private final double fTwoWay;

    public RangeRateTroposphericDelayModifier(TroposphericModel model, boolean tw) {
        this.tropoModel = model;
        this.fTwoWay = tw ? 2.0 : 1.0;
    }

    private double getStationHeightAMSL(GroundStation station) {
        double height = station.getBaseFrame().getPoint().getAltitude();
        return height;
    }

    public double rangeRateErrorTroposphericModel(GroundStation station, SpacecraftState state) throws OrekitException {
        double dt = 10.0;
        double height = this.getStationHeightAMSL(station);
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation1 = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation1 > 0.0) {
            double d1 = this.tropoModel.pathDelay(elevation1, height);
            SpacecraftState state2 = state.shiftedBy(10.0);
            Vector3D position2 = state2.getPVCoordinates().getPosition();
            double elevation2 = station.getBaseFrame().getElevation(position2, state2.getFrame(), state2.getDate());
            double d2 = this.tropoModel.pathDelay(elevation2, height);
            return this.fTwoWay * (d2 - d1) / 10.0;
        }
        return 0.0;
    }

    private double[][] rangeRateErrorJacobianState(final GroundStation station, SpacecraftState refstate, double delay) throws OrekitException {
        double[][] finiteDifferencesJacobian = Differentiation.differentiate(new StateFunction(){

            @Override
            public double[] value(SpacecraftState state) throws OrekitException {
                try {
                    double value = RangeRateTroposphericDelayModifier.this.rangeRateErrorTroposphericModel(station, state);
                    return new double[]{value};
                }
                catch (OrekitException oe) {
                    throw new OrekitExceptionWrapper(oe);
                }
            }
        }, 1, Propagator.DEFAULT_LAW, OrbitType.CARTESIAN, PositionAngle.TRUE, 15.0, 3).value(refstate);
        return finiteDifferencesJacobian;
    }

    private double rangeRateErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state, double delay) throws OrekitException {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) throws OrekitException {
                return RangeRateTroposphericDelayModifier.this.rangeRateErrorTroposphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, driver, 3, 10.0);
        return rangeErrorDerivative.value(driver);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<RangeRate> estimated) throws OrekitException {
        RangeRate measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        double delay = this.rangeRateErrorTroposphericModel(station, state);
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + delay;
        estimated.setEstimatedValue(newValue);
        double[][] djac = this.rangeRateErrorJacobianState(station, state, delay);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        for (ParameterDriver driver : Arrays.asList(station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            double parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeRateErrorParameterDerivative(station, driver, state, delay));
        }
    }
}

