/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.AngularAzEl;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.models.AtmosphericRefractionModel;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public class AngularRadioRefractionModifier
implements EstimationModifier<AngularAzEl> {
    private final AtmosphericRefractionModel atmosModel;

    public AngularRadioRefractionModifier(AtmosphericRefractionModel model) {
        this.atmosModel = model;
    }

    private double angularErrorRadioRefractionModel(GroundStation station, SpacecraftState state) throws OrekitException {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        return this.atmosModel.getRefraction(elevation);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<AngularAzEl> estimated) throws OrekitException {
        AngularAzEl measure = estimated.getObservedMeasurement();
        GroundStation station = measure.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double correction = this.angularErrorRadioRefractionModel(station, state);
        double[] oldValue = estimated.getEstimatedValue();
        double[] newValue = (double[])oldValue.clone();
        newValue[1] = newValue[1] + correction;
        estimated.setEstimatedValue(newValue[0], newValue[1]);
    }
}

