/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.GroundPointing;
import org.orekit.bodies.Ellipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class BodyCenterPointing
extends GroundPointing {
    private static final long serialVersionUID = 20150529L;
    private final Ellipsoid ellipsoid;

    public BodyCenterPointing(Frame inertialFrame, Ellipsoid shape) throws OrekitException {
        super(inertialFrame, shape.getFrame());
        this.ellipsoid = shape;
    }

    @Override
    public TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        TimeStampedPVCoordinates scInBodyFrame = pvProv.getPVCoordinates(date, this.getBodyFrame());
        double u = scInBodyFrame.getPosition().getX() / this.ellipsoid.getA();
        double v = scInBodyFrame.getPosition().getY() / this.ellipsoid.getB();
        double w = scInBodyFrame.getPosition().getZ() / this.ellipsoid.getC();
        double d2 = u * u + v * v + w * w;
        double d = FastMath.sqrt((double)d2);
        double ratio = 1.0 / d;
        Vector3D projectedP = new Vector3D(ratio, scInBodyFrame.getPosition());
        double uDot = scInBodyFrame.getVelocity().getX() / this.ellipsoid.getA();
        double vDot = scInBodyFrame.getVelocity().getY() / this.ellipsoid.getB();
        double wDot = scInBodyFrame.getVelocity().getZ() / this.ellipsoid.getC();
        double dDot = MathArrays.linearCombination((double)u, (double)uDot, (double)v, (double)vDot, (double)w, (double)wDot) / d;
        double ratioDot = -dDot / d2;
        Vector3D projectedV = new Vector3D(ratio, scInBodyFrame.getVelocity(), ratioDot, scInBodyFrame.getPosition());
        double uDotDot = scInBodyFrame.getAcceleration().getX() / this.ellipsoid.getA();
        double vDotDot = scInBodyFrame.getAcceleration().getY() / this.ellipsoid.getB();
        double wDotDot = scInBodyFrame.getAcceleration().getZ() / this.ellipsoid.getC();
        double dDotDot = (MathArrays.linearCombination((double)u, (double)uDotDot, (double)v, (double)vDotDot, (double)w, (double)wDotDot) + uDot * uDot + vDot * vDot + wDot * wDot - dDot * dDot) / d;
        double ratioDotDot = (2.0 * dDot * dDot - d * dDotDot) / (d * d2);
        Vector3D projectedA = new Vector3D(ratio, scInBodyFrame.getAcceleration(), 2.0 * ratioDot, scInBodyFrame.getVelocity(), ratioDotDot, scInBodyFrame.getPosition());
        TimeStampedPVCoordinates projected = new TimeStampedPVCoordinates(date, projectedP, projectedV, projectedA);
        return this.getBodyFrame().getTransformTo(frame, date).transformPVCoordinates(projected);
    }

    @Override
    public <T extends RealFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPV(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) throws OrekitException {
        TimeStampedFieldPVCoordinates<T> scInBodyFrame = pvProv.getPVCoordinates(date, this.getBodyFrame());
        RealFieldElement u = (RealFieldElement)scInBodyFrame.getPosition().getX().divide(this.ellipsoid.getA());
        RealFieldElement v = (RealFieldElement)scInBodyFrame.getPosition().getY().divide(this.ellipsoid.getB());
        RealFieldElement w = (RealFieldElement)scInBodyFrame.getPosition().getZ().divide(this.ellipsoid.getC());
        RealFieldElement d2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)u.pow(2)).add(v.pow(2))).add(w.pow(2));
        RealFieldElement d = (RealFieldElement)d2.sqrt();
        RealFieldElement ratio = (RealFieldElement)d.reciprocal();
        FieldVector3D projectedP = new FieldVector3D(ratio, scInBodyFrame.getPosition());
        RealFieldElement uDot = (RealFieldElement)scInBodyFrame.getVelocity().getX().divide(this.ellipsoid.getA());
        RealFieldElement vDot = (RealFieldElement)scInBodyFrame.getVelocity().getY().divide(this.ellipsoid.getB());
        RealFieldElement wDot = (RealFieldElement)scInBodyFrame.getVelocity().getZ().divide(this.ellipsoid.getC());
        RealFieldElement dDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)u.multiply((Object)uDot)).add(v.multiply((Object)vDot))).add(w.multiply((Object)wDot))).divide((Object)d);
        RealFieldElement ratioDot = (RealFieldElement)((RealFieldElement)dDot.multiply(-1)).divide((Object)d2);
        FieldVector3D projectedV = new FieldVector3D(ratio, scInBodyFrame.getVelocity(), ratioDot, scInBodyFrame.getPosition());
        RealFieldElement uDotDot = (RealFieldElement)scInBodyFrame.getAcceleration().getX().divide(this.ellipsoid.getA());
        RealFieldElement vDotDot = (RealFieldElement)scInBodyFrame.getAcceleration().getY().divide(this.ellipsoid.getB());
        RealFieldElement wDotDot = (RealFieldElement)scInBodyFrame.getAcceleration().getZ().divide(this.ellipsoid.getC());
        RealFieldElement dDotDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)u.multiply((Object)uDotDot)).add(v.multiply((Object)vDotDot))).add(((RealFieldElement)w.multiply((Object)wDotDot)).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)uDot.pow(2)).add(vDot.pow(2))).add(wDot.pow(2))).subtract(dDot.pow(2))))).divide((Object)d);
        RealFieldElement ratioDotDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dDot.pow(2)).multiply(2)).subtract(d.multiply((Object)dDotDot))).divide(d.multiply((Object)d2));
        FieldVector3D projectedA = new FieldVector3D(ratio, scInBodyFrame.getAcceleration(), (RealFieldElement)ratioDot.multiply(2), scInBodyFrame.getVelocity(), ratioDotDot, scInBodyFrame.getPosition());
        TimeStampedFieldPVCoordinates<T> projected = new TimeStampedFieldPVCoordinates<T>(date, projectedP, projectedV, projectedA);
        return this.getBodyFrame().getTransformTo(frame, date.toAbsoluteDate()).transformPVCoordinates(projected);
    }
}

