/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.util.Arrays;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldTuple<T extends RealFieldElement<T>>
implements RealFieldElement<FieldTuple<T>> {
    private final T[] values;
    private final transient FieldTupleField<T> field;

    @SafeVarargs
    public FieldTuple(T ... x) {
        this(new FieldTupleField(x[0].getField(), x.length), (RealFieldElement[])x.clone());
    }

    private FieldTuple(FieldTupleField<T> field, T[] x) {
        this.values = x;
        this.field = field;
    }

    public int getDimension() {
        return this.values.length;
    }

    public T getComponent(int index) {
        return this.values[index];
    }

    public T[] getComponents() {
        return (RealFieldElement[])this.values.clone();
    }

    @Override
    public Field<FieldTuple<T>> getField() {
        return this.field;
    }

    @Override
    public FieldTuple<T> add(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].add(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> subtract(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].subtract(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> negate() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].negate();
        }
        return result;
    }

    @Override
    public FieldTuple<T> multiply(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].multiply(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> multiply(int n) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].multiply((int)n);
        }
        return result;
    }

    @Override
    public FieldTuple<T> divide(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].divide(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> reciprocal() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].reciprocal();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldTuple) {
            FieldTuple that = (FieldTuple)obj;
            if (this.getDimension() == that.getDimension()) {
                boolean equals = true;
                for (int i = 0; i < this.values.length; ++i) {
                    equals &= this.values[i].equals(that.values[i]);
                }
                return equals;
            }
        }
        return false;
    }

    public int hashCode() {
        return 1492524517 + Arrays.hashCode(this.values);
    }

    @Override
    public double getReal() {
        return this.values[0].getReal();
    }

    @Override
    public FieldTuple<T> add(double a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].add(a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> subtract(double a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].subtract(a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> multiply(double a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].multiply(a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> divide(double a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].divide(a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> remainder(double a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].remainder((double)a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> remainder(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].remainder(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> abs() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].abs();
        }
        return result;
    }

    @Override
    public FieldTuple<T> ceil() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].ceil();
        }
        return result;
    }

    @Override
    public FieldTuple<T> floor() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].floor();
        }
        return result;
    }

    @Override
    public FieldTuple<T> rint() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].rint();
        }
        return result;
    }

    @Override
    public long round() {
        return this.values[0].round();
    }

    @Override
    public FieldTuple<T> signum() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].signum();
        }
        return result;
    }

    @Override
    public FieldTuple<T> copySign(FieldTuple<T> sign) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].copySign(sign.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> copySign(double sign) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].copySign(sign);
        }
        return result;
    }

    @Override
    public FieldTuple<T> scalb(int n) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].scalb(n);
        }
        return result;
    }

    @Override
    public FieldTuple<T> hypot(FieldTuple<T> y) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].hypot(y.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> sqrt() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].sqrt();
        }
        return result;
    }

    @Override
    public FieldTuple<T> cbrt() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].cbrt();
        }
        return result;
    }

    @Override
    public FieldTuple<T> rootN(int n) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].rootN(n);
        }
        return result;
    }

    @Override
    public FieldTuple<T> pow(double p) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].pow((double)p);
        }
        return result;
    }

    @Override
    public FieldTuple<T> pow(int n) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].pow((int)n);
        }
        return result;
    }

    @Override
    public FieldTuple<T> pow(FieldTuple<T> e) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].pow(e.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> exp() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].exp();
        }
        return result;
    }

    @Override
    public FieldTuple<T> expm1() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].expm1();
        }
        return result;
    }

    @Override
    public FieldTuple<T> log() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].log();
        }
        return result;
    }

    @Override
    public FieldTuple<T> log1p() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].log1p();
        }
        return result;
    }

    @Override
    public FieldTuple<T> log10() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].log10();
        }
        return result;
    }

    @Override
    public FieldTuple<T> cos() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].cos();
        }
        return result;
    }

    @Override
    public FieldTuple<T> sin() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].sin();
        }
        return result;
    }

    @Override
    public FieldTuple<T> tan() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].tan();
        }
        return result;
    }

    @Override
    public FieldTuple<T> acos() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].acos();
        }
        return result;
    }

    @Override
    public FieldTuple<T> asin() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].asin();
        }
        return result;
    }

    @Override
    public FieldTuple<T> atan() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].atan();
        }
        return result;
    }

    @Override
    public FieldTuple<T> atan2(FieldTuple<T> x) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].atan2(x.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> cosh() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].cosh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> sinh() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].sinh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> tanh() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].tanh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> acosh() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].acosh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> asinh() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].asinh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> atanh() {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)this.values[i].atanh();
        }
        return result;
    }

    public FieldTuple<T> linearCombination(FieldTuple<T>[] a, FieldTuple<T>[] b) throws MathIllegalArgumentException {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        MathUtils.checkDimension(a.length, b.length);
        RealFieldElement[] aT = (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), a.length);
        RealFieldElement[] bT = (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), b.length);
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                aT[j] = a[j].values[i];
                bT[j] = b[j].values[i];
            }
            result.values[i] = aT[0].linearCombination(aT, bT);
        }
        return result;
    }

    public FieldTuple<T> linearCombination(double[] a, FieldTuple<T>[] b) throws MathIllegalArgumentException {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        MathUtils.checkDimension(a.length, b.length);
        RealFieldElement[] bT = (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), b.length);
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                bT[j] = b[j].values[i];
            }
            result.values[i] = bT[0].linearCombination(a, (T[])bT);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(FieldTuple<T> a1, FieldTuple<T> b1, FieldTuple<T> a2, FieldTuple<T> b2) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)a1.values[0].linearCombination(a1.values[i], b1.values[i], a2.values[i], b2.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(double a1, FieldTuple<T> b1, double a2, FieldTuple<T> b2) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)b1.values[0].linearCombination(a1, b1.values[i], a2, b2.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(FieldTuple<T> a1, FieldTuple<T> b1, FieldTuple<T> a2, FieldTuple<T> b2, FieldTuple<T> a3, FieldTuple<T> b3) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)a1.values[0].linearCombination(a1.values[i], b1.values[i], a2.values[i], b2.values[i], a3.values[i], b3.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(double a1, FieldTuple<T> b1, double a2, FieldTuple<T> b2, double a3, FieldTuple<T> b3) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)b1.values[0].linearCombination(a1, b1.values[i], a2, b2.values[i], a3, b3.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(FieldTuple<T> a1, FieldTuple<T> b1, FieldTuple<T> a2, FieldTuple<T> b2, FieldTuple<T> a3, FieldTuple<T> b3, FieldTuple<T> a4, FieldTuple<T> b4) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)a1.values[0].linearCombination(a1.values[i], b1.values[i], a2.values[i], b2.values[i], a3.values[i], b3.values[i], a4.values[i], b4.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(double a1, FieldTuple<T> b1, double a2, FieldTuple<T> b2, double a3, FieldTuple<T> b3, double a4, FieldTuple<T> b4) {
        FieldTuple result = new FieldTuple(this.field, (RealFieldElement[])MathArrays.buildArray(this.values[0].getField(), this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (RealFieldElement)b1.values[0].linearCombination(a1, b1.values[i], a2, b2.values[i], a3, b3.values[i], a4, b4.values[i]);
        }
        return result;
    }

    private static class FieldTupleField<T extends RealFieldElement<T>>
    implements Field<FieldTuple<T>> {
        private final FieldTuple<T> zero;
        private final FieldTuple<T> one;

        FieldTupleField(Field<T> field, int dimension) {
            Object[] zeroData = (RealFieldElement[])MathArrays.buildArray(field, dimension);
            Arrays.fill(zeroData, field.getZero());
            Object[] oneData = (RealFieldElement[])MathArrays.buildArray(field, dimension);
            Arrays.fill(oneData, field.getOne());
            this.zero = new FieldTuple(this, (RealFieldElement[])zeroData);
            this.one = new FieldTuple(this, (RealFieldElement[])oneData);
        }

        @Override
        public FieldTuple<T> getZero() {
            return this.zero;
        }

        @Override
        public FieldTuple<T> getOne() {
            return this.one;
        }

        @Override
        public Class<? extends FieldElement<FieldTuple<T>>> getRuntimeClass() {
            return this.zero.getClass();
        }

        public boolean equals(Object other) {
            if (other instanceof FieldTupleField) {
                FieldTupleField that = (FieldTupleField)other;
                return this.zero.getDimension() == that.zero.getDimension();
            }
            return false;
        }

        public int hashCode() {
            return 0xB4A533E1 ^ this.zero.getDimension();
        }
    }
}

