/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.io.Serializable;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.SphericalPolygonsSetTransferObject;

public class GeographicZoneDetector
extends AbstractDetector<GeographicZoneDetector> {
    private static final long serialVersionUID = 20140619L;
    private BodyShape body;
    private final transient SphericalPolygonsSet zone;
    private final transient EnclosingBall<Sphere2D, S2Point> cap;
    private final double margin;

    public GeographicZoneDetector(BodyShape body, SphericalPolygonsSet zone, double margin) {
        this(600.0, 1.0E-6, body, zone, margin);
    }

    public GeographicZoneDetector(double maxCheck, double threshold, BodyShape body, SphericalPolygonsSet zone, double margin) {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), body, zone, (EnclosingBall<Sphere2D, S2Point>)zone.getEnclosingCap(), margin);
    }

    private GeographicZoneDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super GeographicZoneDetector> handler, BodyShape body, SphericalPolygonsSet zone, EnclosingBall<Sphere2D, S2Point> cap, double margin) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
        this.zone = zone;
        this.cap = cap;
        this.margin = margin;
    }

    @Override
    protected GeographicZoneDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super GeographicZoneDetector> newHandler) {
        return new GeographicZoneDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.zone, this.cap, this.margin);
    }

    public GeographicZoneDetector withMargin(double newMargin) {
        return new GeographicZoneDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.body, this.zone, this.cap, newMargin);
    }

    public BodyShape getBody() {
        return this.body;
    }

    public SphericalPolygonsSet getZone() {
        return this.zone;
    }

    public double getMargin() {
        return this.margin;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        GeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        S2Point s2p = new S2Point(gp.getLongitude(), 1.5707963267948966 - gp.getLatitude());
        double crudeDistance = ((S2Point)this.cap.getCenter()).distance((Point)s2p) - this.cap.getRadius();
        if (crudeDistance - this.margin > FastMath.max((double)FastMath.abs((double)this.margin), (double)0.01)) {
            return crudeDistance - this.margin;
        }
        return this.zone.projectToBoundary((Point)s2p).getOffset() - this.margin;
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20140619L;
        private final double maxCheck;
        private final double threshold;
        private final int maxIter;
        private final BodyShape body;
        private final double margin;
        private final SphericalPolygonsSetTransferObject zone;

        private DTO(GeographicZoneDetector detector) {
            this.maxCheck = detector.getMaxCheckInterval();
            this.threshold = detector.getThreshold();
            this.maxIter = detector.getMaxIterationCount();
            this.body = detector.body;
            this.margin = detector.margin;
            this.zone = new SphericalPolygonsSetTransferObject(detector.zone);
        }

        private Object readResolve() {
            return ((GeographicZoneDetector)((GeographicZoneDetector)new GeographicZoneDetector(this.body, this.zone.rebuildZone(), this.margin).withMaxCheck(this.maxCheck)).withThreshold(this.threshold)).withMaxIter(this.maxIter);
        }
    }
}

