/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.frames.Transform;
import org.orekit.models.AtmosphericRefractionModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnDecreasing;
import org.orekit.utils.ElevationMask;

public class FieldElevationDetector<T extends RealFieldElement<T>>
extends FieldAbstractDetector<FieldElevationDetector<T>, T> {
    private final ElevationMask elevationMask;
    private final double minElevation;
    private final AtmosphericRefractionModel refractionModel;
    private final TopocentricFrame topo;

    public FieldElevationDetector(Field<T> field, TopocentricFrame topo) {
        this((RealFieldElement)((RealFieldElement)field.getZero()).add(600.0), (RealFieldElement)((RealFieldElement)field.getZero()).add(1.0E-6), topo);
    }

    public FieldElevationDetector(T maxCheck, T threshold, TopocentricFrame topo) {
        this(maxCheck, threshold, 100, new FieldStopOnDecreasing(), 0.0, null, null, topo);
    }

    private FieldElevationDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldElevationDetector<T>, T> handler, double minElevation, ElevationMask mask, AtmosphericRefractionModel refractionModel, TopocentricFrame topo) {
        super(maxCheck, threshold, maxIter, handler);
        this.minElevation = minElevation;
        this.elevationMask = mask;
        this.refractionModel = refractionModel;
        this.topo = topo;
    }

    @Override
    protected FieldElevationDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldElevationDetector<T>, T> newHandler) {
        return new FieldElevationDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.minElevation, this.elevationMask, this.refractionModel, this.topo);
    }

    public ElevationMask getElevationMask() {
        return this.elevationMask;
    }

    public double getMinElevation() {
        return this.minElevation;
    }

    public AtmosphericRefractionModel getRefractionModel() {
        return this.refractionModel;
    }

    public TopocentricFrame getTopocentricFrame() {
        return this.topo;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) throws OrekitException {
        Transform t = s.getFrame().getTransformTo((Frame)this.topo, s.getDate().toAbsoluteDate());
        FieldVector3D extPointTopo = t.transformPosition(s.getPVCoordinates().getPosition());
        RealFieldElement trueElevation = extPointTopo.getDelta();
        RealFieldElement calculatedElevation = this.refractionModel != null ? (RealFieldElement)trueElevation.add(this.refractionModel.getRefraction(trueElevation.getReal())) : trueElevation;
        if (this.elevationMask != null) {
            double azimuth = FastMath.atan2((double)extPointTopo.getY().getReal(), (double)extPointTopo.getX().getReal());
            return (T)((RealFieldElement)calculatedElevation.subtract(this.elevationMask.getElevation(azimuth)));
        }
        return (T)((RealFieldElement)calculatedElevation.subtract(this.minElevation));
    }

    public FieldElevationDetector<T> withConstantElevation(double newMinElevation) {
        return new FieldElevationDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newMinElevation, null, this.refractionModel, this.topo);
    }

    public FieldElevationDetector<T> withElevationMask(ElevationMask newElevationMask) {
        return new FieldElevationDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), Double.NaN, newElevationMask, this.refractionModel, this.topo);
    }

    public FieldElevationDetector<T> withRefraction(AtmosphericRefractionModel newRefractionModel) {
        return new FieldElevationDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.minElevation, this.elevationMask, newRefractionModel, this.topo);
    }
}

