/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import org.hipparchus.analysis.BivariateFunction;
import org.hipparchus.analysis.interpolation.PiecewiseBicubicSplineInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.TroposphericModel;
import org.orekit.utils.InterpolationTableLoader;

public class FixedTroposphericDelay
implements TroposphericModel {
    private static final long serialVersionUID = -92320711761929077L;
    private static FixedTroposphericDelay defaultModel;
    private final double[] xArr;
    private final double[] yArr;
    private final double[][] fArr;
    private transient BivariateFunction delayFunction;

    public FixedTroposphericDelay(double[] xArr, double[] yArr, double[][] fArr) {
        this.xArr = (double[])xArr.clone();
        this.yArr = (double[])yArr.clone();
        this.fArr = (double[][])fArr.clone();
        this.delayFunction = new PiecewiseBicubicSplineInterpolator().interpolate(xArr, yArr, fArr);
    }

    public FixedTroposphericDelay(String supportedName) throws OrekitException {
        InterpolationTableLoader loader = new InterpolationTableLoader();
        DataProvidersManager.getInstance().feed(supportedName, loader);
        if (!loader.stillAcceptsData()) {
            this.xArr = loader.getAbscissaGrid();
            this.yArr = loader.getOrdinateGrid();
            for (int i = 0; i < this.yArr.length; ++i) {
                this.yArr[i] = FastMath.toRadians((double)this.yArr[i]);
            }
        } else {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_RESOURCE, supportedName);
        }
        this.fArr = loader.getValuesSamples();
        this.delayFunction = new PiecewiseBicubicSplineInterpolator().interpolate(this.xArr, this.yArr, this.fArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FixedTroposphericDelay getDefaultModel() throws OrekitException {
        Class<FixedTroposphericDelay> clazz = FixedTroposphericDelay.class;
        synchronized (FixedTroposphericDelay.class) {
            if (defaultModel == null) {
                defaultModel = new FixedTroposphericDelay("^tropospheric-delay\\.txt$");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultModel;
        }
    }

    @Override
    public double pathDelay(double elevation, double height) {
        double h = FastMath.min((double)FastMath.max((double)0.0, (double)height), (double)5000.0);
        double ele = FastMath.min((double)Math.PI, (double)FastMath.max((double)0.0, (double)elevation));
        double e = ele > 1.5707963267948966 ? Math.PI - ele : ele;
        return this.delayFunction.value(h, e);
    }

    private Object readResolve() {
        return new FixedTroposphericDelay(this.xArr, this.yArr, this.fArr);
    }
}

