/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class Glonass
extends AbstractGNSSAttitudeProvider {
    private static final long serialVersionUID = 20171114L;
    private static final double NIGHT_TURN_LIMIT = FastMath.toRadians((double)165.8);
    private static final double YAW_RATE = FastMath.toRadians((double)0.25);
    private static final double YAW_END_ZERO = FastMath.toRadians((double)75.0);

    public Glonass(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) throws OrekitException {
        double realBeta = context.getBeta();
        double muRate = context.getMuRate();
        double aNight = NIGHT_TURN_LIMIT;
        double aNoon = FastMath.atan((double)(muRate / YAW_RATE));
        if (FastMath.abs((double)realBeta) < aNoon) {
            double yawEnd = YAW_END_ZERO;
            for (int i = 0; i < 3; ++i) {
                double delta = muRate * yawEnd / YAW_RATE;
                yawEnd = 0.5 * FastMath.abs((double)(context.computePhi(realBeta, delta) - context.computePhi(realBeta, -delta)));
            }
            aNoon = muRate * yawEnd / YAW_RATE;
        }
        double cNoon = FastMath.cos((double)aNoon);
        double cNight = FastMath.cos((double)aNight);
        if (context.setUpTurnRegion(cNight, cNoon)) {
            context.setHalfSpan(context.inSunSide() ? aNoon : context.inOrbitPlaneAbsoluteAngle(aNight - Math.PI));
            if (context.inTurnTimeRange(context.getDate(), 0.0)) {
                double linearPhi;
                double phiDot;
                double beta = context.getSecuredBeta();
                double phiStart = context.getYawStart(beta);
                double dtStart = context.timeSinceTurnStart(context.getDate());
                double phiEnd = context.getYawEnd(beta);
                if (context.inSunSide()) {
                    phiDot = -FastMath.copySign((double)YAW_RATE, (double)beta);
                    linearPhi = phiStart + phiDot * dtStart;
                } else {
                    phiDot = FastMath.copySign((double)YAW_RATE, (double)beta);
                    linearPhi = phiStart + phiDot * dtStart;
                }
                if (phiEnd / linearPhi < 0.0 || phiEnd / linearPhi > 1.0) {
                    return context.turnCorrectedAttitude(phiEnd, 0.0);
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.getNominalYaw();
    }

    @Override
    protected <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) throws OrekitException {
        Field<T> field = context.getDate().getField();
        T realBeta = context.getBeta();
        T muRate = context.getMuRate();
        RealFieldElement aNight = (RealFieldElement)((RealFieldElement)field.getZero()).add(NIGHT_TURN_LIMIT);
        RealFieldElement aNoon = FastMath.atan((RealFieldElement)((RealFieldElement)muRate.divide(YAW_RATE)));
        if (FastMath.abs(realBeta).getReal() < aNoon.getReal()) {
            RealFieldElement yawEnd = (RealFieldElement)((RealFieldElement)field.getZero()).add(YAW_END_ZERO);
            for (int i = 0; i < 3; ++i) {
                RealFieldElement delta = (RealFieldElement)((RealFieldElement)muRate.multiply((Object)yawEnd)).divide(YAW_RATE);
                yawEnd = (RealFieldElement)FastMath.abs((RealFieldElement)((RealFieldElement)context.computePhi((RealFieldElement)realBeta, delta).subtract((Object)context.computePhi((RealFieldElement)realBeta, (RealFieldElement)delta.negate())))).multiply(0.5);
            }
            aNoon = (RealFieldElement)((RealFieldElement)muRate.multiply((Object)yawEnd)).divide(YAW_RATE);
        }
        double cNoon = FastMath.cos((double)aNoon.getReal());
        double cNight = FastMath.cos((double)aNight.getReal());
        if (context.setUpTurnRegion(cNight, cNoon)) {
            context.setHalfSpan(context.inSunSide() ? aNoon : context.inOrbitPlaneAbsoluteAngle((RealFieldElement)aNight.subtract(Math.PI)));
            if (context.inTurnTimeRange(context.getDate(), 0.0)) {
                RealFieldElement linearPhi;
                RealFieldElement phiDot;
                T beta = context.getSecuredBeta();
                T phiStart = context.getYawStart((RealFieldElement)beta);
                T dtStart = context.timeSinceTurnStart(context.getDate());
                T phiEnd = context.getYawEnd((RealFieldElement)beta);
                if (context.inSunSide()) {
                    phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(-FastMath.copySign((double)YAW_RATE, (double)beta.getReal()));
                    linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                } else {
                    phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(FastMath.copySign((double)YAW_RATE, (double)beta.getReal()));
                    linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                }
                if (phiEnd.getReal() / linearPhi.getReal() < 0.0 || phiEnd.getReal() / linearPhi.getReal() > 1.0) {
                    return context.turnCorrectedAttitude((RealFieldElement)phiEnd, (RealFieldElement)field.getZero());
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.getNominalYaw();
    }
}

