/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.antenna;

import java.util.HashMap;
import java.util.Map;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;

public enum SatelliteAntennaCode {
    BEIDOU_2G("BEIDOU-2G"),
    BEIDOU_2I("BEIDOU-2I"),
    BEIDOU_2M("BEIDOU-2M"),
    BEIDOU_3I("BEIDOU-3I"),
    BLOCK_I("BLOCK I"),
    BLOCK_II("BLOCK II"),
    BLOCK_IIA("BLOCK IIA"),
    BLOCK_IIR_A("BLOCK IIR-A"),
    BLOCK_IIR_B("BLOCK IIR-B"),
    BLOCK_IIR_M("BLOCK IIR-M"),
    BLOCK_IIF("BLOCK IIF"),
    BLOCK_IIIA("BLOCK IIIA"),
    GALILEO_0A("GALILEO-0A"),
    GALILEO_0B("GALILEO-0B"),
    GALILEO_1("GALILEO-1"),
    GALILEO_2("GALILEO-2"),
    GLONASS("GLONASS"),
    GLONASS_M("GLONASS-M"),
    GLONASS_K1("GLONASS-K1"),
    GLONASS_K2("GLONASS-K2"),
    IRNSS_1GEO("IRNSS-1GEO"),
    IRNSS_1IGSO("IRNSS-1IGSO"),
    QZSS("QZSS"),
    QZSS_2I("QZSS-2I"),
    QZSS_2G("QZSS-2G");

    private static final Map<String, SatelliteAntennaCode> NAMES_MAP;
    private final String name;

    private SatelliteAntennaCode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SatelliteAntennaCode parseSatelliteAntennaCode(String s) throws OrekitIllegalArgumentException {
        SatelliteAntennaCode satelliteAntennaCode = NAMES_MAP.get(s);
        if (satelliteAntennaCode == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_SATELLITE_ANTENNA_CODE, s);
        }
        return satelliteAntennaCode;
    }

    static {
        NAMES_MAP = new HashMap<String, SatelliteAntennaCode>();
        for (SatelliteAntennaCode satelliteAntennaCode : SatelliteAntennaCode.values()) {
            NAMES_MAP.put(satelliteAntennaCode.getName(), satelliteAntennaCode);
        }
    }
}

