/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.orekit.bodies.CelestialBody;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.L2TransformProvider;
import org.orekit.frames.ShiftingTransformProvider;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.OrekitConfiguration;

public class L2Frame
extends Frame {
    private static final long serialVersionUID = 20170811L;

    public L2Frame(CelestialBody primaryBody, CelestialBody secondaryBody) throws OrekitException {
        super(primaryBody.getInertiallyOrientedFrame(), new ShiftingTransformProvider(new L2TransformProvider(primaryBody, secondaryBody), CartesianDerivativesFilter.USE_P, AngularDerivativesFilter.USE_R, 5, 3600.0, OrekitConfiguration.getCacheSlotsNumber(), 3.15576E7, 2592000.0), primaryBody.getName() + "-" + secondaryBody.getName() + "-L2", true);
    }
}

