/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.FixedTransformProvider;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class Frame
implements Serializable {
    private static final long serialVersionUID = -6981146543760234087L;
    private final Frame parent;
    private final int depth;
    private final TransformProvider transformProvider;
    private final String name;
    private final boolean pseudoInertial;

    private Frame(String name, boolean pseudoInertial) {
        this.parent = null;
        this.depth = 0;
        this.transformProvider = new FixedTransformProvider(Transform.IDENTITY);
        this.name = name;
        this.pseudoInertial = pseudoInertial;
    }

    public Frame(Frame parent, Transform transform, String name) throws IllegalArgumentException {
        this(parent, transform, name, false);
    }

    public Frame(Frame parent, TransformProvider transformProvider, String name) throws IllegalArgumentException {
        this(parent, transformProvider, name, false);
    }

    public Frame(Frame parent, Transform transform, String name, boolean pseudoInertial) throws IllegalArgumentException {
        this(parent, new FixedTransformProvider(transform), name, pseudoInertial);
    }

    public Frame(Frame parent, TransformProvider transformProvider, String name, boolean pseudoInertial) throws IllegalArgumentException {
        if (parent == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_PARENT_FOR_FRAME, name);
        }
        this.parent = parent;
        this.depth = parent.depth + 1;
        this.transformProvider = transformProvider;
        this.name = name;
        this.pseudoInertial = pseudoInertial;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPseudoInertial() {
        return this.pseudoInertial;
    }

    public String toString() {
        return this.name;
    }

    public Frame getParent() {
        return this.parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public Frame getAncestor(int n) throws IllegalArgumentException {
        if (n > this.depth) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAME_NO_NTH_ANCESTOR, this.name, this.depth, n);
        }
        Frame current = this;
        for (int i = 0; i < n; ++i) {
            current = current.parent;
        }
        return current;
    }

    public Transform getTransformTo(Frame destination, AbsoluteDate date) throws OrekitException {
        if (this == destination) {
            return Transform.IDENTITY;
        }
        Frame common = Frame.findCommon(this, destination);
        Transform commonToInstance = Transform.IDENTITY;
        Frame frame = this;
        while (frame != common) {
            commonToInstance = new Transform(date, frame.transformProvider.getTransform(date), commonToInstance);
            frame = frame.parent;
        }
        Transform commonToDestination = Transform.IDENTITY;
        Frame frame2 = destination;
        while (frame2 != common) {
            commonToDestination = new Transform(date, frame2.transformProvider.getTransform(date), commonToDestination);
            frame2 = frame2.parent;
        }
        return new Transform(date, commonToInstance.getInverse(), commonToDestination);
    }

    public <T extends RealFieldElement<T>> FieldTransform<T> getTransformTo(Frame destination, FieldAbsoluteDate<T> date) throws OrekitException {
        if (this == destination) {
            return FieldTransform.getIdentity(date.getField());
        }
        Frame common = Frame.findCommon(this, destination);
        FieldTransform<T> commonToInstance = FieldTransform.getIdentity(date.getField());
        Frame frame = this;
        while (frame != common) {
            commonToInstance = new FieldTransform<T>(date, frame.transformProvider.getTransform(date), commonToInstance);
            frame = frame.parent;
        }
        FieldTransform<T> commonToDestination = FieldTransform.getIdentity(date.getField());
        Frame frame2 = destination;
        while (frame2 != common) {
            commonToDestination = new FieldTransform<T>(date, frame2.transformProvider.getTransform(date), commonToDestination);
            frame2 = frame2.parent;
        }
        return new FieldTransform<T>(date, commonToInstance.getInverse(), commonToDestination);
    }

    public TransformProvider getTransformProvider() {
        return this.transformProvider;
    }

    private static Frame findCommon(Frame from, Frame to) {
        Frame currentT;
        Frame currentF = from.depth > to.depth ? from.getAncestor(from.depth - to.depth) : from;
        Frame frame = currentT = from.depth > to.depth ? to : to.getAncestor(to.depth - from.depth);
        while (currentF != currentT) {
            currentF = currentF.parent;
            currentT = currentT.parent;
        }
        return currentF;
    }

    public boolean isChildOf(Frame potentialAncestor) {
        if (this.depth <= potentialAncestor.depth) {
            return false;
        }
        return this.getAncestor(this.depth - potentialAncestor.depth) == potentialAncestor;
    }

    protected static Frame getRoot() {
        return LazyRootHolder.INSTANCE;
    }

    public Frame getFrozenFrame(Frame reference, AbsoluteDate freezingDate, String frozenName) throws OrekitException {
        return new Frame(reference, reference.getTransformTo(this, freezingDate).freeze(), frozenName, reference.isPseudoInertial());
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 4067764035816491212L;

        private DataTransferObject() {
        }

        private Object readResolve() {
            return Frame.getRoot();
        }
    }

    private static class LazyRootHolder {
        private static final Frame INSTANCE = new Frame("GCRF", true){
            private static final long serialVersionUID = -2654403496396721543L;

            private Object writeReplace() {
                return new DataTransferObject();
            }
        };

        private LazyRootHolder() {
        }
    }
}

