/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class IsotropicRadiationClassicalConvention
implements RadiationSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final ParameterDriver absorptionParameterDriver;
    private final ParameterDriver reflectionParameterDriver;
    private final double crossSection;
    private final DSFactory factory;

    public IsotropicRadiationClassicalConvention(double crossSection, double ca, double cs) {
        try {
            this.absorptionParameterDriver = new ParameterDriver("absorption coefficient", ca, this.SCALE, 0.0, 1.0);
            this.reflectionParameterDriver = new ParameterDriver("reflection coefficient", cs, this.SCALE, 0.0, 1.0);
            this.factory = new DSFactory(1, 1);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
        this.crossSection = crossSection;
    }

    @Override
    public ParameterDriver[] getRadiationParametersDrivers() {
        return new ParameterDriver[]{this.absorptionParameterDriver, this.reflectionParameterDriver};
    }

    @Override
    public Vector3D radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, double[] parameters) {
        double ca = parameters[0];
        double cs = parameters[1];
        double kP = this.crossSection * (1.0 + 4.0 * (1.0 - ca - cs) / 9.0);
        return new Vector3D(kP / mass, flux);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> radiationPressureAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, FieldVector3D<T> flux, T[] parameters) throws OrekitException {
        T ca = parameters[0];
        T cs = parameters[1];
        RealFieldElement kP = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ca.add(cs)).negate()).add(1.0)).multiply(0.4444444444444444)).add(1.0)).multiply(this.crossSection);
        return new FieldVector3D((RealFieldElement)((RealFieldElement)mass.reciprocal()).multiply((Object)kP), flux);
    }

    @Override
    public FieldVector3D<DerivativeStructure> radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, double[] parameters, String paramName) throws OrekitException {
        DerivativeStructure csDS;
        DerivativeStructure caDS;
        if ("absorption coefficient".equals(paramName)) {
            caDS = this.factory.variable(0, parameters[0]);
            csDS = this.factory.constant(parameters[1]);
        } else if ("reflection coefficient".equals(paramName)) {
            caDS = this.factory.constant(parameters[0]);
            csDS = this.factory.variable(0, parameters[1]);
        } else {
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, "absorption coefficient, reflection coefficient");
        }
        DerivativeStructure kP = caDS.add(csDS).subtract(1.0).multiply(-0.4444444444444444).add(1.0).multiply(this.crossSection);
        return new FieldVector3D((RealFieldElement)kP.divide(mass), flux);
    }
}

