/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class BoxAndSolarArraySpacecraft
implements RadiationSensitive,
DragSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final ParameterDriver dragParameterDriver;
    private final ParameterDriver liftParameterDriver;
    private final ParameterDriver absorptionParameterDriver;
    private final ParameterDriver reflectionParameterDriver;
    private final List<Facet> facets;
    private final double solarArrayArea;
    private final AbsoluteDate referenceDate;
    private final double rotationRate;
    private final Vector3D saX;
    private final Vector3D saY;
    private final Vector3D saZ;
    private final PVCoordinatesProvider sun;
    private final DSFactory factory;

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, dragCoeff, liftRatio, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, dragCoeff, liftRatio, true, absorptionCoeff, reflectionCoeff);
    }

    private BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, boolean useLift, double absorptionCoeff, double reflectionCoeff) {
        this.dragParameterDriver = this.buildDragParameterDriver(dragCoeff);
        this.liftParameterDriver = useLift ? this.buildLiftParameterDriver(liftRatio) : null;
        this.absorptionParameterDriver = this.buildAbsorptionParameterDriver(absorptionCoeff);
        this.reflectionParameterDriver = this.buildReflectionParameterDriver(reflectionCoeff);
        this.factory = new DSFactory(1, 1);
        this.facets = BoxAndSolarArraySpacecraft.filter(facets);
        this.sun = sun;
        this.solarArrayArea = solarArrayArea;
        this.referenceDate = null;
        this.rotationRate = 0.0;
        this.saZ = solarArrayAxis.normalize();
        this.saY = null;
        this.saX = null;
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, liftRatio, true, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, liftRatio, true, absorptionCoeff, reflectionCoeff);
    }

    private BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double liftRatio, boolean useLift, double absorptionCoeff, double reflectionCoeff) {
        this.dragParameterDriver = this.buildDragParameterDriver(dragCoeff);
        this.liftParameterDriver = useLift ? this.buildLiftParameterDriver(liftRatio) : null;
        this.absorptionParameterDriver = this.buildAbsorptionParameterDriver(absorptionCoeff);
        this.reflectionParameterDriver = this.buildReflectionParameterDriver(reflectionCoeff);
        this.factory = new DSFactory(1, 1);
        this.facets = BoxAndSolarArraySpacecraft.filter((Facet[])facets.clone());
        this.sun = sun;
        this.solarArrayArea = solarArrayArea;
        this.referenceDate = referenceDate;
        this.rotationRate = rotationRate;
        this.saZ = solarArrayAxis.normalize();
        this.saY = Vector3D.crossProduct((Vector3D)this.saZ, (Vector3D)referenceNormal).normalize();
        this.saX = Vector3D.crossProduct((Vector3D)this.saY, (Vector3D)this.saZ);
    }

    private ParameterDriver buildDragParameterDriver(double coeff) {
        try {
            return new ParameterDriver("drag coefficient", coeff, this.SCALE, 0.0, Double.POSITIVE_INFINITY);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    private ParameterDriver buildLiftParameterDriver(double coeff) {
        try {
            return new ParameterDriver("lift ratio", coeff, this.SCALE, 0.0, 1.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    private ParameterDriver buildAbsorptionParameterDriver(double coeff) {
        try {
            return new ParameterDriver("absorption coefficient", coeff, this.SCALE, 0.0, 1.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    private ParameterDriver buildReflectionParameterDriver(double coeff) {
        try {
            return new ParameterDriver("reflection coefficient", coeff, this.SCALE, 0.0, 1.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    @Override
    public ParameterDriver[] getDragParametersDrivers() {
        ParameterDriver[] parameterDriverArray;
        if (this.liftParameterDriver == null) {
            ParameterDriver[] parameterDriverArray2 = new ParameterDriver[1];
            parameterDriverArray = parameterDriverArray2;
            parameterDriverArray2[0] = this.dragParameterDriver;
        } else {
            ParameterDriver[] parameterDriverArray3 = new ParameterDriver[2];
            parameterDriverArray3[0] = this.dragParameterDriver;
            parameterDriverArray = parameterDriverArray3;
            parameterDriverArray3[1] = this.liftParameterDriver;
        }
        return parameterDriverArray;
    }

    @Override
    public ParameterDriver[] getRadiationParametersDrivers() {
        return new ParameterDriver[]{this.absorptionParameterDriver, this.reflectionParameterDriver};
    }

    public synchronized Vector3D getNormal(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation) throws OrekitException {
        if (this.referenceDate != null) {
            double alpha = this.rotationRate * date.durationFrom(this.referenceDate);
            return new Vector3D(FastMath.cos((double)alpha), this.saX, FastMath.sin((double)alpha), this.saY);
        }
        Vector3D sunInert = this.sun.getPVCoordinates(date, frame).getPosition().subtract((Vector)position).normalize();
        Vector3D sunSpacecraft = rotation.applyTo(sunInert);
        double d = Vector3D.dotProduct((Vector3D)sunSpacecraft, (Vector3D)this.saZ);
        double f = 1.0 - d * d;
        if (f < Precision.EPSILON) {
            return this.saZ.orthogonal();
        }
        double s = 1.0 / FastMath.sqrt((double)f);
        return new Vector3D(s, sunSpacecraft, -s * d, this.saZ);
    }

    public synchronized <T extends RealFieldElement<T>> FieldVector3D<T> getNormal(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation) throws OrekitException {
        if (this.referenceDate != null) {
            RealFieldElement alpha = (RealFieldElement)date.durationFrom(this.referenceDate).multiply(this.rotationRate);
            return new FieldVector3D((RealFieldElement)alpha.cos(), this.saX, (RealFieldElement)alpha.sin(), this.saY);
        }
        FieldVector3D sunInert = position.subtract(this.sun.getPVCoordinates(date.toAbsoluteDate(), frame).getPosition()).negate().normalize();
        FieldVector3D sunSpacecraft = rotation.applyTo(sunInert);
        RealFieldElement d = FieldVector3D.dotProduct((FieldVector3D)sunSpacecraft, (Vector3D)this.saZ);
        RealFieldElement f = (RealFieldElement)((RealFieldElement)((RealFieldElement)d.multiply((Object)d)).subtract(1.0)).negate();
        if (f.getReal() < Precision.EPSILON) {
            return new FieldVector3D(f.getField(), this.saZ.orthogonal());
        }
        RealFieldElement s = (RealFieldElement)((RealFieldElement)f.sqrt()).reciprocal();
        return new FieldVector3D(s, sunSpacecraft, (RealFieldElement)((RealFieldElement)s.multiply((Object)d)).negate(), new FieldVector3D(date.getField(), this.saZ));
    }

    public synchronized FieldVector3D<DerivativeStructure> getNormal(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldRotation<DerivativeStructure> rotation) throws OrekitException {
        DerivativeStructure zero = (DerivativeStructure)((DerivativeStructure)position.getX()).getField().getZero();
        if (this.referenceDate != null) {
            DerivativeStructure alpha = zero.add(this.rotationRate * date.durationFrom(this.referenceDate));
            return new FieldVector3D((RealFieldElement)alpha.cos(), this.saX, (RealFieldElement)alpha.sin(), this.saY);
        }
        FieldVector3D sunInert = position.subtract(this.sun.getPVCoordinates(date, frame).getPosition()).negate().normalize();
        FieldVector3D sunSpacecraft = rotation.applyTo(sunInert);
        DerivativeStructure d = (DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)sunSpacecraft, (Vector3D)this.saZ);
        DerivativeStructure f = d.multiply(d).subtract(1.0).negate();
        if (f.getValue() < Precision.EPSILON) {
            return new FieldVector3D(((DerivativeStructure)position.getX()).getField(), this.saZ.orthogonal());
        }
        DerivativeStructure s = f.sqrt().reciprocal();
        return new FieldVector3D((RealFieldElement)s, sunSpacecraft, (RealFieldElement)s.multiply(d).negate(), new FieldVector3D(zero.getField(), this.saZ));
    }

    @Override
    public Vector3D dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity, double[] parameters) throws OrekitException {
        double dragCoeff = parameters[0];
        double liftRatio = this.liftParameterDriver == null ? 0.0 : parameters[1];
        double vNorm2 = relativeVelocity.getNormSq();
        double vNorm = FastMath.sqrt((double)vNorm2);
        Vector3D vDir = rotation.applyTo(relativeVelocity.scalarMultiply(1.0 / vNorm));
        double coeff = density * dragCoeff * vNorm2 / (2.0 * mass);
        double oMr = 1.0 - liftRatio;
        Vector3D frontNormal = this.getNormal(date, frame, position, rotation);
        double s = coeff * this.solarArrayArea * Vector3D.dotProduct((Vector3D)frontNormal, (Vector3D)vDir);
        Vector3D acceleration = new Vector3D(oMr * FastMath.abs((double)s), vDir, liftRatio * s * 2.0, frontNormal);
        for (Facet facet : this.facets) {
            double dot = Vector3D.dotProduct((Vector3D)facet.getNormal(), (Vector3D)vDir);
            if (!(dot < 0.0)) continue;
            double f = coeff * facet.getArea() * dot;
            acceleration = new Vector3D(1.0, acceleration, oMr * FastMath.abs((double)f), vDir, liftRatio * f * 2.0, facet.getNormal());
        }
        return rotation.applyInverseTo(acceleration);
    }

    @Override
    public FieldVector3D<DerivativeStructure> dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity, double[] parameters, String paramName) throws OrekitException {
        DerivativeStructure oMrDS;
        DerivativeStructure liftRatioDS;
        DerivativeStructure dragCoeffDS;
        Field field = this.factory.getDerivativeField();
        if (this.dragParameterDriver.getName().equals(paramName)) {
            double liftRatio = this.liftParameterDriver == null ? 0.0 : parameters[1];
            dragCoeffDS = this.factory.variable(0, parameters[0]);
            liftRatioDS = this.factory.constant(liftRatio);
            oMrDS = this.factory.constant(1.0 - liftRatio);
        } else if (this.liftParameterDriver != null && this.liftParameterDriver.getName().equals(paramName)) {
            dragCoeffDS = this.factory.constant(parameters[0]);
            liftRatioDS = this.factory.variable(0, parameters[1]);
            oMrDS = liftRatioDS.negate().add(1.0);
        } else {
            if (this.liftParameterDriver == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, this.dragParameterDriver.getName());
            }
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, this.dragParameterDriver.getName(), this.liftParameterDriver.getName());
        }
        double vNorm2 = relativeVelocity.getNormSq();
        double vNorm = FastMath.sqrt((double)vNorm2);
        FieldVector3D vDir = new FieldVector3D(field, rotation.applyTo(relativeVelocity.scalarMultiply(1.0 / vNorm)));
        DerivativeStructure coeff = dragCoeffDS.multiply(0.5 * density * vNorm2 / mass);
        FieldVector3D frontNormal = new FieldVector3D(field, this.getNormal(date, frame, position, rotation));
        DerivativeStructure s = coeff.multiply(this.solarArrayArea).multiply((DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)frontNormal, (FieldVector3D)vDir));
        FieldVector3D acceleration = new FieldVector3D((RealFieldElement)s.abs().multiply(oMrDS), vDir, (RealFieldElement)s.multiply(liftRatioDS).multiply(2), frontNormal);
        for (Facet facet : this.facets) {
            DerivativeStructure dot = (DerivativeStructure)FieldVector3D.dotProduct((Vector3D)facet.getNormal(), (FieldVector3D)vDir);
            if (!(dot.getValue() < 0.0)) continue;
            DerivativeStructure f = coeff.multiply(facet.getArea()).multiply(dot);
            acceleration = new FieldVector3D((RealFieldElement)field.getOne(), acceleration, (RealFieldElement)f.abs().multiply(oMrDS), vDir, (RealFieldElement)f.multiply(liftRatioDS).multiply(2), new FieldVector3D(field, facet.getNormal()));
        }
        return new FieldRotation(field, rotation).applyInverseTo(acceleration);
    }

    @Override
    public Vector3D radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, double[] parameters) throws OrekitException {
        if (flux.getNormSq() < Precision.SAFE_MIN) {
            return Vector3D.ZERO;
        }
        Vector3D fluxSat = rotation.applyTo(flux);
        Vector3D normal = this.getNormal(date, frame, position, rotation);
        double dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
        if (dot > 0.0) {
            dot = -dot;
            normal = normal.negate();
        }
        Vector3D force = this.facetRadiationAcceleration(normal, this.solarArrayArea, fluxSat, dot, parameters);
        for (Facet bodyFacet : this.facets) {
            normal = bodyFacet.getNormal();
            dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
            if (!(dot < 0.0)) continue;
            force = force.add((Vector)this.facetRadiationAcceleration(normal, bodyFacet.getArea(), fluxSat, dot, parameters));
        }
        return rotation.applyInverseTo(new Vector3D(1.0 / mass, force));
    }

    @Override
    public FieldVector3D<DerivativeStructure> radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, double[] parameters, String paramName) throws OrekitException {
        DerivativeStructure specularReflectionCoeffDS;
        DerivativeStructure absorptionCoeffDS;
        if (flux.getNormSq() < Precision.SAFE_MIN) {
            return FieldVector3D.getZero((Field)this.factory.getDerivativeField());
        }
        if ("absorption coefficient".equals(paramName)) {
            absorptionCoeffDS = this.factory.variable(0, parameters[0]);
            specularReflectionCoeffDS = this.factory.constant(parameters[1]);
        } else if ("reflection coefficient".equals(paramName)) {
            absorptionCoeffDS = this.factory.constant(parameters[0]);
            specularReflectionCoeffDS = this.factory.variable(0, parameters[1]);
        } else {
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, "absorption coefficient, reflection coefficient");
        }
        DerivativeStructure diffuseReflectionCoeffDS = absorptionCoeffDS.add(specularReflectionCoeffDS).subtract(1.0).negate();
        Vector3D fluxSat = rotation.applyTo(flux);
        Vector3D normal = this.getNormal(date, frame, position, rotation);
        double dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
        if (dot > 0.0) {
            dot = -dot;
            normal = normal.negate();
        }
        FieldVector3D force = this.facetRadiationAcceleration(normal, this.solarArrayArea, fluxSat, dot, specularReflectionCoeffDS, diffuseReflectionCoeffDS);
        for (Facet bodyFacet : this.facets) {
            normal = bodyFacet.getNormal();
            dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
            if (!(dot < 0.0)) continue;
            force = force.add(this.facetRadiationAcceleration(normal, bodyFacet.getArea(), fluxSat, dot, specularReflectionCoeffDS, diffuseReflectionCoeffDS));
        }
        return FieldRotation.applyInverseTo((Rotation)rotation, (FieldVector3D)new FieldVector3D(1.0 / mass, force));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> dragAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, T density, FieldVector3D<T> relativeVelocity, T[] parameters) throws OrekitException {
        T dragCoeff = parameters[0];
        Object liftRatio = this.liftParameterDriver == null ? (RealFieldElement)dragCoeff.getField().getZero() : parameters[1];
        RealFieldElement vNorm2 = relativeVelocity.getNormSq();
        RealFieldElement vNorm = (RealFieldElement)vNorm2.sqrt();
        FieldVector3D vDir = rotation.applyTo(relativeVelocity.scalarMultiply((RealFieldElement)vNorm.reciprocal()));
        RealFieldElement coeff = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)density.multiply(0.5)).multiply(dragCoeff)).multiply((Object)vNorm2)).divide(mass);
        RealFieldElement oMr = (RealFieldElement)((RealFieldElement)liftRatio.negate()).add(1.0);
        FieldVector3D<T> frontNormal = this.getNormal(date, frame, position, rotation);
        RealFieldElement s = (RealFieldElement)((RealFieldElement)coeff.multiply(this.solarArrayArea)).multiply((Object)FieldVector3D.dotProduct(frontNormal, (FieldVector3D)vDir));
        FieldVector3D acceleration = new FieldVector3D((RealFieldElement)((RealFieldElement)s.abs()).multiply((Object)oMr), vDir, (RealFieldElement)((RealFieldElement)s.multiply(liftRatio)).multiply(2), frontNormal);
        Field field = coeff.getField();
        for (Facet facet : this.facets) {
            RealFieldElement dot = FieldVector3D.dotProduct((Vector3D)facet.getNormal(), (FieldVector3D)vDir);
            if (!(dot.getReal() < 0.0)) continue;
            RealFieldElement f = (RealFieldElement)((RealFieldElement)coeff.multiply(facet.getArea())).multiply((Object)dot);
            acceleration = new FieldVector3D((RealFieldElement)field.getOne(), acceleration, (RealFieldElement)((RealFieldElement)f.abs()).multiply((Object)oMr), vDir, (RealFieldElement)((RealFieldElement)f.multiply(liftRatio)).multiply(2), new FieldVector3D(field, facet.getNormal()));
        }
        return rotation.applyInverseTo(acceleration);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> radiationPressureAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, FieldVector3D<T> flux, T[] parameters) throws OrekitException {
        if (flux.getNormSq().getReal() < Precision.SAFE_MIN) {
            return FieldVector3D.getZero(date.getField());
        }
        FieldVector3D fluxSat = rotation.applyTo(flux);
        FieldVector3D normal = this.getNormal(date, frame, position, rotation);
        RealFieldElement dot = FieldVector3D.dotProduct(normal, (FieldVector3D)fluxSat);
        if (dot.getReal() > 0.0) {
            dot = (RealFieldElement)dot.negate();
            normal = normal.negate();
        }
        FieldVector3D force = this.facetRadiationAcceleration(normal, this.solarArrayArea, fluxSat, dot, (RealFieldElement[])parameters);
        for (Facet bodyFacet : this.facets) {
            normal = new FieldVector3D(date.getField(), bodyFacet.getNormal());
            dot = FieldVector3D.dotProduct((FieldVector3D)fluxSat, (FieldVector3D)normal);
            if (!(dot.getReal() < 0.0)) continue;
            force = force.add(this.facetRadiationAcceleration(normal, bodyFacet.getArea(), fluxSat, dot, (RealFieldElement[])parameters));
        }
        return rotation.applyInverseTo(new FieldVector3D((RealFieldElement)mass.reciprocal(), force));
    }

    private Vector3D facetRadiationAcceleration(Vector3D normal, double area, Vector3D fluxSat, double dot, double[] parameters) {
        double absorptionCoeff = parameters[0];
        double specularReflectionCoeff = parameters[1];
        double diffuseReflectionCoeff = 1.0 - (absorptionCoeff + specularReflectionCoeff);
        double psr = fluxSat.getNorm();
        double cN = 2.0 * area * dot * (diffuseReflectionCoeff / 3.0 - specularReflectionCoeff * dot / psr);
        double cS = area * dot / psr * (specularReflectionCoeff - 1.0);
        return new Vector3D(cN, normal, cS, fluxSat);
    }

    private <T extends RealFieldElement<T>> FieldVector3D<T> facetRadiationAcceleration(FieldVector3D<T> normal, double area, FieldVector3D<T> fluxSat, T dot, T[] parameters) {
        T absorptionCoeff = parameters[0];
        T specularReflectionCoeff = parameters[1];
        RealFieldElement diffuseReflectionCoeff = (RealFieldElement)((RealFieldElement)((RealFieldElement)absorptionCoeff.add(specularReflectionCoeff)).negate()).add(1.0);
        RealFieldElement psr = fluxSat.getNorm();
        RealFieldElement cN = (RealFieldElement)((RealFieldElement)dot.multiply(-2.0 * area)).multiply(((RealFieldElement)((RealFieldElement)dot.multiply(specularReflectionCoeff)).divide((Object)psr)).subtract(diffuseReflectionCoeff.divide(3.0)));
        RealFieldElement cS = (RealFieldElement)((RealFieldElement)((RealFieldElement)dot.multiply(area)).multiply(specularReflectionCoeff.subtract(1.0))).divide((Object)psr);
        return new FieldVector3D(cN, normal, cS, fluxSat);
    }

    private FieldVector3D<DerivativeStructure> facetRadiationAcceleration(Vector3D normal, double area, Vector3D fluxSat, double dot, DerivativeStructure specularReflectionCoeffDS, DerivativeStructure diffuseReflectionCoeffDS) {
        double psr = fluxSat.getNorm();
        DerivativeStructure cN = diffuseReflectionCoeffDS.divide(3.0).subtract(specularReflectionCoeffDS.multiply(dot / psr)).multiply(2.0 * area * dot);
        DerivativeStructure cS = specularReflectionCoeffDS.subtract(1.0).multiply(area * dot / psr);
        return new FieldVector3D((RealFieldElement)cN, normal, (RealFieldElement)cS, fluxSat);
    }

    private static Facet[] simpleBoxFacets(double xLength, double yLength, double zLength) {
        return new Facet[]{new Facet(Vector3D.MINUS_I, yLength * zLength), new Facet(Vector3D.PLUS_I, yLength * zLength), new Facet(Vector3D.MINUS_J, xLength * zLength), new Facet(Vector3D.PLUS_J, xLength * zLength), new Facet(Vector3D.MINUS_K, xLength * yLength), new Facet(Vector3D.PLUS_K, xLength * yLength)};
    }

    private static List<Facet> filter(Facet[] facets) {
        ArrayList<Facet> filtered = new ArrayList<Facet>(facets.length);
        for (Facet facet : facets) {
            if (!(facet.getArea() > 0.0)) continue;
            filtered.add(facet);
        }
        return filtered;
    }

    public static class Facet {
        private final Vector3D normal;
        private final double area;

        public Facet(Vector3D normal, double area) {
            this.normal = normal.normalize();
            this.area = area;
        }

        public Vector3D getNormal() {
            return this.normal;
        }

        public double getArea() {
            return this.area;
        }
    }
}

