/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Phase
extends AbstractMeasurement<Phase> {
    private final GroundStation station;
    private final double wavelength;

    public Phase(GroundStation station, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight) throws OrekitException {
        this(station, date, phase, wavelength, sigma, baseWeight, 0);
    }

    public Phase(GroundStation station, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight, int propagatorIndex) throws OrekitException {
        super(date, phase, sigma, baseWeight, Arrays.asList(propagatorIndex), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver(), station.getPrimeMeridianOffsetDriver(), station.getPrimeMeridianDriftDriver(), station.getPolarOffsetXDriver(), station.getPolarDriftXDriver(), station.getPolarOffsetYDriver(), station.getPolarDriftYDriver());
        this.station = station;
        this.wavelength = wavelength;
    }

    public GroundStation getStation() {
        return this.station;
    }

    @Override
    protected EstimatedMeasurement<Phase> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) throws OrekitException {
        SpacecraftState state = states[this.getPropagatorsIndices().get(0)];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        DSFactory factory = new DSFactory(nbParams, 1);
        Field field = factory.getDerivativeField();
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        TimeStampedFieldPVCoordinates<DerivativeStructure> pvaDS = Phase.getCoordinates(state, 0, factory);
        AbsoluteDate downlinkDate = this.getDate();
        FieldAbsoluteDate<DerivativeStructure> downlinkDateDS = new FieldAbsoluteDate<DerivativeStructure>(field, downlinkDate);
        FieldTransform<DerivativeStructure> offsetToInertialDownlink = this.station.getOffsetToInertial(state.getFrame(), downlinkDateDS, factory, indices);
        TimeStampedFieldPVCoordinates<DerivativeStructure> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<DerivativeStructure>(downlinkDateDS, zero, zero, zero));
        DerivativeStructure tauD = Phase.signalTimeOfFlight(pvaDS, stationDownlink.getPosition(), downlinkDateDS);
        double delta = downlinkDate.durationFrom(state.getDate());
        DerivativeStructure deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitStateDS = pvaDS.shiftedBy((RealFieldElement)deltaMTauD);
        EstimatedMeasurement<Phase> estimated = new EstimatedMeasurement<Phase>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationDownlink.toTimeStampedPVCoordinates()});
        double cOverLambda = 2.99792458E8 / this.wavelength;
        DerivativeStructure phase = tauD.multiply(cOverLambda);
        estimated.setEstimatedValue(phase.getValue());
        double[] derivatives = phase.getAllDerivatives();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 1, 7)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index + 1]);
        }
        return estimated;
    }
}

