/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Map;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.BodiesElements;
import org.orekit.data.FundamentalNutationArguments;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.EstimatedEarthFrameProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.TopocentricFrame;
import org.orekit.frames.Transform;
import org.orekit.models.earth.displacement.StationDisplacement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UT1Scale;
import org.orekit.utils.ParameterDriver;

public class GroundStation {
    public static final String OFFSET_SUFFIX = "-offset";
    public static final String INTERMEDIATE_SUFFIX = "-intermediate";
    private static final double OFFSET_SCALE = FastMath.scalb((double)1.0, (int)0);
    private final EstimatedEarthFrameProvider estimatedEarthFrameProvider;
    private final Frame estimatedEarthFrame;
    private final TopocentricFrame baseFrame;
    private final FundamentalNutationArguments arguments;
    private final StationDisplacement[] displacements;
    private final ParameterDriver eastOffsetDriver;
    private final ParameterDriver northOffsetDriver;
    private final ParameterDriver zenithOffsetDriver;

    public GroundStation(TopocentricFrame baseFrame) throws OrekitException {
        this(baseFrame, FramesFactory.findEOP(baseFrame), new StationDisplacement[0]);
    }

    public GroundStation(TopocentricFrame baseFrame, EOPHistory eopHistory, StationDisplacement ... displacements) throws OrekitException {
        this.baseFrame = baseFrame;
        if (eopHistory == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_EARTH_ORIENTATION_PARAMETERS, new Object[0]);
        }
        UT1Scale baseUT1 = TimeScalesFactory.getUT1(eopHistory);
        this.estimatedEarthFrameProvider = new EstimatedEarthFrameProvider(baseUT1);
        this.estimatedEarthFrame = new Frame(baseFrame.getParent(), this.estimatedEarthFrameProvider, baseFrame.getParent() + "-estimated");
        this.arguments = displacements.length == 0 ? null : eopHistory.getConventions().getNutationArguments(this.estimatedEarthFrameProvider.getEstimatedUT1());
        this.displacements = (StationDisplacement[])displacements.clone();
        this.eastOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-East", 0.0, OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.northOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-North", 0.0, OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.zenithOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-Zenith", 0.0, OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public StationDisplacement[] getDisplacements() {
        return (StationDisplacement[])this.displacements.clone();
    }

    public ParameterDriver getEastOffsetDriver() {
        return this.eastOffsetDriver;
    }

    public ParameterDriver getNorthOffsetDriver() {
        return this.northOffsetDriver;
    }

    public ParameterDriver getZenithOffsetDriver() {
        return this.zenithOffsetDriver;
    }

    public ParameterDriver getPrimeMeridianOffsetDriver() {
        return this.estimatedEarthFrameProvider.getPrimeMeridianOffsetDriver();
    }

    public ParameterDriver getPrimeMeridianDriftDriver() {
        return this.estimatedEarthFrameProvider.getPrimeMeridianDriftDriver();
    }

    public ParameterDriver getPolarOffsetXDriver() {
        return this.estimatedEarthFrameProvider.getPolarOffsetXDriver();
    }

    public ParameterDriver getPolarDriftXDriver() {
        return this.estimatedEarthFrameProvider.getPolarDriftXDriver();
    }

    public ParameterDriver getPolarOffsetYDriver() {
        return this.estimatedEarthFrameProvider.getPolarOffsetYDriver();
    }

    public ParameterDriver getPolarDriftYDriver() {
        return this.estimatedEarthFrameProvider.getPolarDriftYDriver();
    }

    public TopocentricFrame getBaseFrame() {
        return this.baseFrame;
    }

    public Frame getEstimatedEarthFrame() {
        return this.estimatedEarthFrame;
    }

    public UT1Scale getEstimatedUT1() {
        return this.estimatedEarthFrameProvider.getEstimatedUT1();
    }

    @Deprecated
    public GeodeticPoint getOffsetGeodeticPoint() throws OrekitException {
        return this.getOffsetGeodeticPoint(null);
    }

    private Vector3D computeDisplacement(AbsoluteDate date, Vector3D position) throws OrekitException {
        try {
            Vector3D displacement = Vector3D.ZERO;
            if (this.arguments != null) {
                BodiesElements elements = this.arguments.evaluateAll(date);
                for (StationDisplacement sd : this.displacements) {
                    displacement = displacement.add((Vector)sd.displacement(elements, this.estimatedEarthFrame, position));
                }
            }
            return displacement;
        }
        catch (OrekitExceptionWrapper oew) {
            throw oew.getException();
        }
    }

    public GeodeticPoint getOffsetGeodeticPoint(AbsoluteDate date) throws OrekitException {
        double x = this.parametricModel(this.eastOffsetDriver);
        double y = this.parametricModel(this.northOffsetDriver);
        double z = this.parametricModel(this.zenithOffsetDriver);
        BodyShape baseShape = this.baseFrame.getParentShape();
        Transform baseToBody = this.baseFrame.getTransformTo(baseShape.getBodyFrame(), date);
        Vector3D origin = baseToBody.transformPosition(new Vector3D(x, y, z));
        if (date != null) {
            origin = origin.add((Vector)this.computeDisplacement(date, origin));
        }
        return baseShape.transform(origin, baseShape.getBodyFrame(), null);
    }

    public Transform getOffsetToInertial(Frame inertial, AbsoluteDate date) throws OrekitException {
        Transform intermediateToBody = this.estimatedEarthFrameProvider.getTransform(date).getInverse();
        double x = this.parametricModel(this.eastOffsetDriver);
        double y = this.parametricModel(this.northOffsetDriver);
        double z = this.parametricModel(this.zenithOffsetDriver);
        BodyShape baseShape = this.baseFrame.getParentShape();
        Transform baseToBody = this.baseFrame.getTransformTo(baseShape.getBodyFrame(), date);
        Vector3D origin = baseToBody.transformPosition(new Vector3D(x, y, z));
        origin = origin.add((Vector)this.computeDisplacement(date, origin));
        GeodeticPoint originGP = baseShape.transform(origin, baseShape.getBodyFrame(), date);
        Transform offsetToIntermediate = new Transform(date, new Transform(date, new Rotation(Vector3D.PLUS_I, Vector3D.PLUS_K, originGP.getEast(), originGP.getZenith()), Vector3D.ZERO), new Transform(date, origin));
        Transform bodyToInert = this.baseFrame.getParent().getTransformTo(inertial, date);
        return new Transform(date, offsetToIntermediate, new Transform(date, intermediateToBody, bodyToInert));
    }

    public FieldTransform<DerivativeStructure> getOffsetToInertial(Frame inertial, FieldAbsoluteDate<DerivativeStructure> date, DSFactory factory, Map<String, Integer> indices) throws OrekitException {
        Field<DerivativeStructure> field = date.getField();
        FieldVector3D zero = FieldVector3D.getZero(field);
        FieldVector3D plusI = FieldVector3D.getPlusI(field);
        FieldVector3D plusK = FieldVector3D.getPlusK(field);
        FieldTransform<DerivativeStructure> intermediateToBody = this.estimatedEarthFrameProvider.getTransform(date, factory, indices).getInverse();
        DerivativeStructure x = this.parametricModel(factory, this.eastOffsetDriver, indices);
        DerivativeStructure y = this.parametricModel(factory, this.northOffsetDriver, indices);
        DerivativeStructure z = this.parametricModel(factory, this.zenithOffsetDriver, indices);
        BodyShape baseShape = this.baseFrame.getParentShape();
        Transform baseToBody = this.baseFrame.getTransformTo(baseShape.getBodyFrame(), (AbsoluteDate)null);
        FieldVector3D origin = baseToBody.transformPosition(new FieldVector3D((RealFieldElement)x, (RealFieldElement)y, (RealFieldElement)z));
        origin = origin.add(this.computeDisplacement(date.toAbsoluteDate(), origin.toVector3D()));
        FieldGeodeticPoint<DerivativeStructure> originGP = baseShape.transform(origin, baseShape.getBodyFrame(), date);
        FieldTransform<DerivativeStructure> offsetToIntermediate = new FieldTransform<DerivativeStructure>(date, new FieldTransform<DerivativeStructure>(date, new FieldRotation(plusI, plusK, originGP.getEast(), originGP.getZenith()), zero), new FieldTransform<DerivativeStructure>(date, origin));
        FieldTransform<DerivativeStructure> bodyToInert = this.baseFrame.getParent().getTransformTo(inertial, date);
        return new FieldTransform<DerivativeStructure>(date, offsetToIntermediate, new FieldTransform<DerivativeStructure>(date, intermediateToBody, bodyToInert));
    }

    private double parametricModel(ParameterDriver driver) {
        return driver.getValue();
    }

    private DerivativeStructure parametricModel(DSFactory factory, ParameterDriver driver, Map<String, Integer> indices) {
        Integer index = indices.get(driver.getName());
        return index == null ? factory.constant(driver.getValue()) : factory.variable(index.intValue(), driver.getValue());
    }
}

