/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.io.Serializable;
import java.util.Map;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.UT1Scale;
import org.orekit.utils.ParameterDriver;

public class EstimatedEarthFrameProvider
implements TransformProvider {
    public static final double EARTH_ANGULAR_VELOCITY = 7.292115146706979E-5;
    private static final long serialVersionUID = 20170922L;
    private static final double ANGULAR_SCALE = FastMath.scalb((double)1.0, (int)-22);
    private final UT1Scale baseUT1;
    private final transient UT1Scale estimatedUT1;
    private final transient ParameterDriver primeMeridianOffsetDriver = new ParameterDriver("prime-meridian-offset", 0.0, ANGULAR_SCALE, -Math.PI, Math.PI);
    private final transient ParameterDriver primeMeridianDriftDriver = new ParameterDriver("prime-meridian-drift", 0.0, ANGULAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final transient ParameterDriver polarOffsetXDriver = new ParameterDriver("polar-offset-X", 0.0, ANGULAR_SCALE, -Math.PI, Math.PI);
    private final transient ParameterDriver polarDriftXDriver = new ParameterDriver("polar-drift-X", 0.0, ANGULAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final transient ParameterDriver polarOffsetYDriver = new ParameterDriver("polar-offset-Y", 0.0, ANGULAR_SCALE, -Math.PI, Math.PI);
    private final transient ParameterDriver polarDriftYDriver = new ParameterDriver("polar-drift-Y", 0.0, ANGULAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);

    public EstimatedEarthFrameProvider(UT1Scale baseUT1) throws OrekitException {
        this.baseUT1 = baseUT1;
        this.estimatedUT1 = new EstimatedUT1Scale();
    }

    public ParameterDriver getPrimeMeridianOffsetDriver() {
        return this.primeMeridianOffsetDriver;
    }

    public ParameterDriver getPrimeMeridianDriftDriver() {
        return this.primeMeridianDriftDriver;
    }

    public ParameterDriver getPolarOffsetXDriver() {
        return this.polarOffsetXDriver;
    }

    public ParameterDriver getPolarDriftXDriver() {
        return this.polarDriftXDriver;
    }

    public ParameterDriver getPolarOffsetYDriver() {
        return this.polarOffsetYDriver;
    }

    public ParameterDriver getPolarDriftYDriver() {
        return this.polarDriftYDriver;
    }

    public UT1Scale getEstimatedUT1() {
        return this.estimatedUT1;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) throws OrekitException {
        double theta = this.linearModel(date, this.primeMeridianOffsetDriver, this.primeMeridianDriftDriver);
        double thetaDot = this.parametricModel(this.primeMeridianDriftDriver);
        Transform meridianShift = new Transform(date, new Rotation(Vector3D.PLUS_K, theta, RotationConvention.FRAME_TRANSFORM), new Vector3D(0.0, 0.0, thetaDot));
        double xpNeg = -this.linearModel(date, this.polarOffsetXDriver, this.polarDriftXDriver);
        double ypNeg = -this.linearModel(date, this.polarOffsetYDriver, this.polarDriftYDriver);
        double xpNegDot = -this.parametricModel(this.polarDriftXDriver);
        double ypNegDot = -this.parametricModel(this.polarDriftYDriver);
        Transform poleShift = new Transform(date, new Transform(date, new Rotation(Vector3D.PLUS_J, xpNeg, RotationConvention.FRAME_TRANSFORM), new Vector3D(0.0, xpNegDot, 0.0)), new Transform(date, new Rotation(Vector3D.PLUS_I, ypNeg, RotationConvention.FRAME_TRANSFORM), new Vector3D(ypNegDot, 0.0, 0.0)));
        return new Transform(date, meridianShift, poleShift);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) throws OrekitException {
        RealFieldElement zero = (RealFieldElement)date.getField().getZero();
        T theta = this.linearModel(date, this.primeMeridianOffsetDriver, this.primeMeridianDriftDriver);
        RealFieldElement thetaDot = (RealFieldElement)zero.add(this.parametricModel(this.primeMeridianDriftDriver));
        RealFieldElement xpNeg = (RealFieldElement)this.linearModel(date, this.polarOffsetXDriver, this.polarDriftXDriver).negate();
        RealFieldElement ypNeg = (RealFieldElement)this.linearModel(date, this.polarOffsetYDriver, this.polarDriftYDriver).negate();
        RealFieldElement xpNegDot = (RealFieldElement)zero.subtract(this.parametricModel(this.polarDriftXDriver));
        RealFieldElement ypNegDot = (RealFieldElement)zero.subtract(this.parametricModel(this.polarDriftYDriver));
        return this.getTransform(date, theta, (T)thetaDot, (T)xpNeg, (T)xpNegDot, (T)ypNeg, (T)ypNegDot);
    }

    public FieldTransform<DerivativeStructure> getTransform(FieldAbsoluteDate<DerivativeStructure> date, DSFactory factory, Map<String, Integer> indices) throws OrekitException {
        DerivativeStructure theta = this.linearModel(factory, date, this.primeMeridianOffsetDriver, this.primeMeridianDriftDriver, indices);
        DerivativeStructure thetaDot = this.parametricModel(factory, this.primeMeridianDriftDriver, indices);
        DerivativeStructure xpNeg = this.linearModel(factory, date, this.polarOffsetXDriver, this.polarDriftXDriver, indices).negate();
        DerivativeStructure ypNeg = this.linearModel(factory, date, this.polarOffsetYDriver, this.polarDriftYDriver, indices).negate();
        DerivativeStructure xpNegDot = this.parametricModel(factory, this.polarDriftXDriver, indices).negate();
        DerivativeStructure ypNegDot = this.parametricModel(factory, this.polarDriftYDriver, indices).negate();
        return this.getTransform(date, theta, thetaDot, xpNeg, xpNegDot, ypNeg, ypNegDot);
    }

    private <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date, T theta, T thetaDot, T xpNeg, T xpNegDot, T ypNeg, T ypNegDot) throws OrekitException {
        RealFieldElement zero = (RealFieldElement)date.getField().getZero();
        FieldVector3D plusI = FieldVector3D.getPlusI(date.getField());
        FieldVector3D plusJ = FieldVector3D.getPlusJ(date.getField());
        FieldVector3D plusK = FieldVector3D.getPlusK(date.getField());
        FieldTransform<T> meridianShift = new FieldTransform<T>(date, new FieldRotation(plusK, theta, RotationConvention.FRAME_TRANSFORM), new FieldVector3D(zero, zero, thetaDot));
        FieldTransform<T> poleShift = new FieldTransform<T>(date, new FieldTransform<T>(date, new FieldRotation(plusJ, xpNeg, RotationConvention.FRAME_TRANSFORM), new FieldVector3D(zero, xpNegDot, zero)), new FieldTransform<T>(date, new FieldRotation(plusI, ypNeg, RotationConvention.FRAME_TRANSFORM), new FieldVector3D(ypNegDot, zero, zero)));
        return new FieldTransform<T>(date, meridianShift, poleShift);
    }

    private double linearModel(AbsoluteDate date, ParameterDriver offsetDriver, ParameterDriver driftDriver) throws OrekitException {
        if (offsetDriver.getReferenceDate() == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_REFERENCE_DATE_FOR_PARAMETER, offsetDriver.getName());
        }
        double dt = date.durationFrom(offsetDriver.getReferenceDate());
        double offset = this.parametricModel(offsetDriver);
        double drift = this.parametricModel(driftDriver);
        return dt * drift + offset;
    }

    private <T extends RealFieldElement<T>> T linearModel(FieldAbsoluteDate<T> date, ParameterDriver offsetDriver, ParameterDriver driftDriver) throws OrekitException {
        if (offsetDriver.getReferenceDate() == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_REFERENCE_DATE_FOR_PARAMETER, offsetDriver.getName());
        }
        T dt = date.durationFrom(offsetDriver.getReferenceDate());
        double offset = this.parametricModel(offsetDriver);
        double drift = this.parametricModel(driftDriver);
        return (T)((RealFieldElement)((RealFieldElement)dt.multiply(drift)).add(offset));
    }

    private DerivativeStructure linearModel(DSFactory factory, FieldAbsoluteDate<DerivativeStructure> date, ParameterDriver offsetDriver, ParameterDriver driftDriver, Map<String, Integer> indices) throws OrekitException {
        if (offsetDriver.getReferenceDate() == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_REFERENCE_DATE_FOR_PARAMETER, offsetDriver.getName());
        }
        DerivativeStructure dt = date.durationFrom(offsetDriver.getReferenceDate());
        DerivativeStructure offset = this.parametricModel(factory, offsetDriver, indices);
        DerivativeStructure drift = this.parametricModel(factory, driftDriver, indices);
        return dt.multiply(drift).add(offset);
    }

    private double parametricModel(ParameterDriver driver) {
        return driver.getValue();
    }

    private DerivativeStructure parametricModel(DSFactory factory, ParameterDriver driver, Map<String, Integer> indices) {
        Integer index = indices.get(driver.getName());
        return index == null ? factory.constant(driver.getValue()) : factory.variable(index.intValue(), driver.getValue());
    }

    private Object writeReplace() {
        return new DataTransferObject(this.baseUT1, this.primeMeridianOffsetDriver.getValue(), this.primeMeridianDriftDriver.getValue(), this.polarOffsetXDriver.getValue(), this.polarDriftXDriver.getValue(), this.polarOffsetYDriver.getValue(), this.polarDriftYDriver.getValue());
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20171124L;
        private final UT1Scale baseUT1;
        private final double primeMeridianOffset;
        private final double primeMeridianDrift;
        private final double polarOffsetX;
        private final double polarDriftX;
        private final double polarOffsetY;
        private final double polarDriftY;

        DataTransferObject(UT1Scale baseUT1, double primeMeridianOffset, double primeMeridianDrift, double polarOffsetX, double polarDriftX, double polarOffsetY, double polarDriftY) {
            this.baseUT1 = baseUT1;
            this.primeMeridianOffset = primeMeridianOffset;
            this.primeMeridianDrift = primeMeridianDrift;
            this.polarOffsetX = polarOffsetX;
            this.polarDriftX = polarDriftX;
            this.polarOffsetY = polarOffsetY;
            this.polarDriftY = polarDriftY;
        }

        private Object readResolve() {
            try {
                EstimatedEarthFrameProvider provider = new EstimatedEarthFrameProvider(this.baseUT1);
                provider.getPrimeMeridianOffsetDriver().setValue(this.primeMeridianOffset);
                provider.getPrimeMeridianDriftDriver().setValue(this.primeMeridianDrift);
                provider.getPolarOffsetXDriver().setValue(this.polarOffsetX);
                provider.getPolarDriftXDriver().setValue(this.polarDriftX);
                provider.getPolarOffsetYDriver().setValue(this.polarOffsetY);
                provider.getPolarDriftYDriver().setValue(this.polarDriftY);
                return provider;
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }

    private class EstimatedUT1Scale
    extends UT1Scale {
        private static final long serialVersionUID = 20170922L;

        EstimatedUT1Scale() {
            super(EstimatedEarthFrameProvider.this.baseUT1.getEOPHistory(), EstimatedEarthFrameProvider.this.baseUT1.getUTCScale());
        }

        @Override
        public <T extends RealFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
            try {
                RealFieldElement dut1 = (RealFieldElement)EstimatedEarthFrameProvider.this.linearModel(date, EstimatedEarthFrameProvider.this.primeMeridianOffsetDriver, EstimatedEarthFrameProvider.this.primeMeridianDriftDriver).divide(7.292115146706979E-5);
                return (T)((RealFieldElement)EstimatedEarthFrameProvider.this.baseUT1.offsetFromTAI(date).add((Object)dut1));
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        @Override
        public double offsetFromTAI(AbsoluteDate date) throws OrekitExceptionWrapper {
            try {
                double dut1 = EstimatedEarthFrameProvider.this.linearModel(date, EstimatedEarthFrameProvider.this.primeMeridianOffsetDriver, EstimatedEarthFrameProvider.this.primeMeridianDriftDriver) / 7.292115146706979E-5;
                return EstimatedEarthFrameProvider.this.baseUT1.offsetFromTAI(date) + dut1;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        @Override
        public String getName() {
            return EstimatedEarthFrameProvider.this.baseUT1.getName() + "/estimated";
        }
    }
}

