/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularRaDec
extends AbstractMeasurement<AngularRaDec> {
    private final GroundStation station;
    private final Frame referenceFrame;

    public AngularRaDec(GroundStation station, Frame referenceFrame, AbsoluteDate date, double[] angular, double[] sigma, double[] baseWeight) throws OrekitException {
        this(station, referenceFrame, date, angular, sigma, baseWeight, 0);
    }

    public AngularRaDec(GroundStation station, Frame referenceFrame, AbsoluteDate date, double[] angular, double[] sigma, double[] baseWeight, int propagatorIndex) throws OrekitException {
        super(date, angular, sigma, baseWeight, Arrays.asList(propagatorIndex), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver(), station.getPrimeMeridianOffsetDriver(), station.getPrimeMeridianDriftDriver(), station.getPolarOffsetXDriver(), station.getPolarDriftXDriver(), station.getPolarOffsetYDriver(), station.getPolarDriftYDriver());
        this.station = station;
        this.referenceFrame = referenceFrame;
    }

    public GroundStation getStation() {
        return this.station;
    }

    public Frame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    protected EstimatedMeasurement<AngularRaDec> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) throws OrekitException {
        SpacecraftState state = states[this.getPropagatorsIndices().get(0)];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        DSFactory factory = new DSFactory(nbParams, 1);
        Field field = factory.getDerivativeField();
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        TimeStampedFieldPVCoordinates<DerivativeStructure> pvaDS = AngularRaDec.getCoordinates(state, 0, factory);
        AbsoluteDate downlinkDate = this.getDate();
        FieldAbsoluteDate<DerivativeStructure> downlinkDateDS = new FieldAbsoluteDate<DerivativeStructure>(field, downlinkDate);
        FieldTransform<DerivativeStructure> offsetToInertialDownlink = this.station.getOffsetToInertial(state.getFrame(), downlinkDateDS, factory, indices);
        TimeStampedFieldPVCoordinates<DerivativeStructure> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<DerivativeStructure>(downlinkDateDS, zero, zero, zero));
        DerivativeStructure tauD = AngularRaDec.signalTimeOfFlight(pvaDS, stationDownlink.getPosition(), downlinkDateDS);
        double delta = downlinkDate.durationFrom(state.getDate());
        DerivativeStructure deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitStateDS = pvaDS.shiftedBy((RealFieldElement)deltaMTauD);
        FieldVector3D staSatInertial = transitStateDS.getPosition().subtract(stationDownlink.getPosition());
        FieldTransform<DerivativeStructure> inertialToReferenceDownlink = state.getFrame().getTransformTo(this.referenceFrame, downlinkDateDS);
        FieldVector3D<DerivativeStructure> staSatReference = inertialToReferenceDownlink.transformPosition((FieldVector3D<DerivativeStructure>)staSatInertial);
        DerivativeStructure baseRightAscension = (DerivativeStructure)staSatReference.getAlpha();
        double twoPiWrap = MathUtils.normalizeAngle((double)baseRightAscension.getReal(), (double)this.getObservedValue()[0]) - baseRightAscension.getReal();
        DerivativeStructure rightAscension = baseRightAscension.add(twoPiWrap);
        DerivativeStructure declination = (DerivativeStructure)staSatReference.getDelta();
        EstimatedMeasurement<AngularRaDec> estimated = new EstimatedMeasurement<AngularRaDec>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationDownlink.toTimeStampedPVCoordinates()});
        estimated.setEstimatedValue(rightAscension.getValue(), declination.getValue());
        double[] raDerivatives = rightAscension.getAllDerivatives();
        double[] decDerivatives = declination.getAllDerivatives();
        estimated.setStateDerivatives(0, Arrays.copyOfRange(raDerivatives, 1, 7), Arrays.copyOfRange(decDerivatives, 1, 7));
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, raDerivatives[index + 1], decDerivatives[index + 1]);
        }
        return estimated;
    }
}

