/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.errors;

import java.text.MessageFormat;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathRuntimeException;
import org.orekit.errors.LocalizedException;

public class OrekitException
extends Exception
implements LocalizedException {
    private static final long serialVersionUID = 20150611L;
    private final Localizable specifier;
    private final Object[] parts;

    public OrekitException(Localizable specifier, Object ... parts) {
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    public OrekitException(OrekitException exception) {
        super(exception);
        this.specifier = exception.specifier;
        this.parts = (Object[])exception.parts.clone();
    }

    public OrekitException(Localizable message, Throwable cause) {
        super(cause);
        this.specifier = message;
        this.parts = new Object[0];
    }

    public OrekitException(Throwable cause, Localizable specifier, Object ... parts) {
        super(cause);
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    public OrekitException(MathRuntimeException exception) {
        super(exception);
        this.specifier = exception.getSpecifier();
        this.parts = exception.getParts();
    }

    @Override
    public String getMessage(Locale locale) {
        return OrekitException.buildMessage(locale, this.specifier, this.parts);
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    @Override
    public Localizable getSpecifier() {
        return this.specifier;
    }

    @Override
    public Object[] getParts() {
        return (Object[])this.parts.clone();
    }

    public static OrekitException unwrap(MathRuntimeException exception) {
        for (Throwable t = exception; t != null; t = t.getCause()) {
            if (!(t instanceof OrekitException)) continue;
            return (OrekitException)t;
        }
        return new OrekitException(exception);
    }

    private static String buildMessage(Locale locale, Localizable specifier, Object ... parts) {
        if (specifier == null) {
            return "";
        }
        String localizedString = specifier.getLocalizedString(locale);
        if (localizedString == null) {
            return "";
        }
        return new MessageFormat(localizedString, locale).format(parts);
    }
}

