/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.io.Serializable;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;

public class StatisticalSummaryValues
implements Serializable,
StatisticalSummary {
    private static final long serialVersionUID = 20160406L;
    private final double mean;
    private final double variance;
    private final long n;
    private final double max;
    private final double min;
    private final double sum;

    public StatisticalSummaryValues(double mean, double variance, long n, double max, double min, double sum) {
        this.mean = mean;
        this.variance = variance;
        this.n = n;
        this.max = max;
        this.min = min;
        this.sum = sum;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public double getStandardDeviation() {
        return FastMath.sqrt((double)this.variance);
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatisticalSummaryValues)) {
            return false;
        }
        StatisticalSummary other = (StatisticalSummary)object;
        return Precision.equalsIncludingNaN((double)other.getMax(), (double)this.getMax()) && Precision.equalsIncludingNaN((double)other.getMean(), (double)this.getMean()) && Precision.equalsIncludingNaN((double)other.getMin(), (double)this.getMin()) && Precision.equalsIncludingNaN((float)other.getN(), (float)this.getN()) && Precision.equalsIncludingNaN((double)other.getSum(), (double)this.getSum()) && Precision.equalsIncludingNaN((double)other.getVariance(), (double)this.getVariance());
    }

    public int hashCode() {
        int result = 31 + MathUtils.hash((double)this.getMax());
        result = result * 31 + MathUtils.hash((double)this.getMean());
        result = result * 31 + MathUtils.hash((double)this.getMin());
        result = result * 31 + MathUtils.hash((double)this.getN());
        result = result * 31 + MathUtils.hash((double)this.getSum());
        result = result * 31 + MathUtils.hash((double)this.getVariance());
        return result;
    }

    public String toString() {
        StringBuilder outBuffer = new StringBuilder();
        String endl = "\n";
        outBuffer.append("StatisticalSummaryValues:").append(endl);
        outBuffer.append("n: ").append(this.getN()).append(endl);
        outBuffer.append("min: ").append(this.getMin()).append(endl);
        outBuffer.append("max: ").append(this.getMax()).append(endl);
        outBuffer.append("mean: ").append(this.getMean()).append(endl);
        outBuffer.append("std dev: ").append(this.getStandardDeviation()).append(endl);
        outBuffer.append("variance: ").append(this.getVariance()).append(endl);
        outBuffer.append("sum: ").append(this.getSum()).append(endl);
        return outBuffer.toString();
    }
}

