/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.discrete;

import org.hipparchus.distribution.discrete.AbstractIntegerDistribution;
import org.hipparchus.distribution.discrete.SaddlePointExpansion;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.special.Beta;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class BinomialDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20160320L;
    private final int numberOfTrials;
    private final double probabilityOfSuccess;

    public BinomialDistribution(int trials, double p) throws MathIllegalArgumentException {
        if (trials < 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_TRIALS, trials);
        }
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        this.probabilityOfSuccess = p;
        this.numberOfTrials = trials;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        double logProbability = this.logProbability(x);
        return logProbability == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(logProbability);
    }

    @Override
    public double logProbability(int x) {
        if (this.numberOfTrials == 0) {
            return x == 0 ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        double ret = x < 0 || x > this.numberOfTrials ? Double.NEGATIVE_INFINITY : SaddlePointExpansion.logBinomialProbability(x, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess);
        return ret;
    }

    @Override
    public double cumulativeProbability(int x) {
        double ret = x < 0 ? 0.0 : (x >= this.numberOfTrials ? 1.0 : 1.0 - Beta.regularizedBeta(this.probabilityOfSuccess, (double)x + 1.0, this.numberOfTrials - x));
        return ret;
    }

    @Override
    public double getNumericalMean() {
        return (double)this.numberOfTrials * this.probabilityOfSuccess;
    }

    @Override
    public double getNumericalVariance() {
        double p = this.probabilityOfSuccess;
        return (double)this.numberOfTrials * p * (1.0 - p);
    }

    @Override
    public int getSupportLowerBound() {
        return this.probabilityOfSuccess < 1.0 ? 0 : this.numberOfTrials;
    }

    @Override
    public int getSupportUpperBound() {
        return this.probabilityOfSuccess > 0.0 ? this.numberOfTrials : 0;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

