/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.UTF8Control;

public enum LocalizedOptimFormats implements Localizable
{
    EQUAL_VERTICES_IN_SIMPLEX("equal vertices {0} and {1} in simplex configuration"),
    INVALID_IMPLEMENTATION("required functionality is missing in {0}"),
    NO_FEASIBLE_SOLUTION("no feasible solution"),
    SIMPLEX_NEED_ONE_POINT("simplex must contain at least one point"),
    TOO_SMALL_COST_RELATIVE_TOLERANCE("cost relative tolerance is too small ({0}), no further reduction in the sum of squares is possible"),
    TOO_SMALL_ORTHOGONALITY_TOLERANCE("orthogonality tolerance is too small ({0}), solution is orthogonal to the jacobian"),
    TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE("parameters relative tolerance is too small ({0}), no further improvement in the approximate solution is possible"),
    TRUST_REGION_STEP_FAILED("trust region step has failed to reduce Q"),
    UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN("unable to perform Q.R decomposition on the {0}x{1} jacobian matrix"),
    UNABLE_TO_SOLVE_SINGULAR_PROBLEM("unable to solve: singular problem"),
    UNBOUNDED_SOLUTION("unbounded solution");

    private final String sourceFormat;

    private LocalizedOptimFormats(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public String getSourceString() {
        return this.sourceFormat;
    }

    public String getLocalizedString(Locale locale) {
        try {
            String translated;
            String path = LocalizedOptimFormats.class.getName().replaceAll("\\.", "/");
            ResourceBundle bundle = ResourceBundle.getBundle("assets/" + path, locale, (ResourceBundle.Control)new UTF8Control());
            if (bundle.getLocale().getLanguage().equals(locale.getLanguage()) && (translated = bundle.getString(this.name())) != null && translated.length() > 0 && !translated.toLowerCase().contains("missing translation")) {
                return translated;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.sourceFormat;
    }
}

