/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.random;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.random.BaseRandomGenerator;

abstract class LongRandomGenerator
extends BaseRandomGenerator {
    private static final long DOUBLE_HIGH_BITS = 0x3FF0000000000000L;

    LongRandomGenerator() {
    }

    @Override
    public abstract long nextLong();

    @Override
    public int nextInt() {
        long v = this.nextLong();
        return (int)(v >>> 32) ^ (int)v;
    }

    @Override
    public double nextDouble() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.nextLong() >>> 12) - 1.0;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextLong() >>> 63 != 0L;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextInt() >>> 9) * 1.1920929E-7f;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.nextBytesFill(bytes, 0, bytes.length);
    }

    @Override
    public void nextBytes(byte[] bytes, int start, int len) {
        if (start < 0 || start >= bytes.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, start, 0, bytes.length);
        }
        if (len < 0 || len > bytes.length - start) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, len, 0, bytes.length - start);
        }
        this.nextBytesFill(bytes, start, len);
    }

    private void nextBytesFill(byte[] bytes, int offset, int len) {
        int index = offset;
        int indexLoopLimit = index + (len & 0x7FFFFFF8);
        while (index < indexLoopLimit) {
            long random = this.nextLong();
            bytes[index++] = (byte)random;
            bytes[index++] = (byte)(random >>> 8);
            bytes[index++] = (byte)(random >>> 16);
            bytes[index++] = (byte)(random >>> 24);
            bytes[index++] = (byte)(random >>> 32);
            bytes[index++] = (byte)(random >>> 40);
            bytes[index++] = (byte)(random >>> 48);
            bytes[index++] = (byte)(random >>> 56);
        }
        int indexLimit = offset + len;
        if (index < indexLimit) {
            long random = this.nextLong();
            while (true) {
                bytes[index++] = (byte)random;
                if (index >= indexLimit) break;
                random >>>= 8;
            }
        }
    }
}

