/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ApsideDetector
extends AbstractDetector<ApsideDetector> {
    private static final long serialVersionUID = 20131118L;

    public ApsideDetector(Orbit orbit) {
        this(1.0E-13 * orbit.getKeplerianPeriod(), orbit);
    }

    public ApsideDetector(double threshold, Orbit orbit) {
        super(orbit.getKeplerianPeriod() / 3.0, threshold, 100, new StopOnIncreasing());
    }

    private ApsideDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super ApsideDetector> handler) {
        super(maxCheck, threshold, maxIter, handler);
    }

    @Override
    protected ApsideDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super ApsideDetector> newHandler) {
        return new ApsideDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        TimeStampedPVCoordinates pv = s.getPVCoordinates();
        return Vector3D.dotProduct((Vector3D)pv.getPosition(), (Vector3D)pv.getVelocity());
    }
}

