/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.util.FastMath;

public class FieldDenseOutputModel<T extends RealFieldElement<T>>
implements FieldODEStepHandler<T> {
    private T initialTime = null;
    private T finalTime = null;
    private boolean forward = true;
    private int index = 0;
    private List<FieldODEStateInterpolator<T>> steps = new ArrayList<FieldODEStateInterpolator<T>>();

    public void append(FieldDenseOutputModel<T> model) throws MathIllegalArgumentException, MathIllegalStateException {
        if (model.steps.size() == 0) {
            return;
        }
        if (this.steps.size() == 0) {
            this.initialTime = model.initialTime;
            this.forward = model.forward;
        } else {
            FieldODEStateAndDerivative<T> s1 = this.steps.get(0).getPreviousState();
            FieldODEStateAndDerivative<T> s2 = model.steps.get(0).getPreviousState();
            this.checkDimensionsEquality(s1.getPrimaryStateDimension(), s2.getPrimaryStateDimension());
            this.checkDimensionsEquality(s1.getNumberOfSecondaryStates(), s2.getNumberOfSecondaryStates());
            for (int i = 0; i < s1.getNumberOfSecondaryStates(); ++i) {
                this.checkDimensionsEquality(s1.getSecondaryStateDimension(i), s2.getSecondaryStateDimension(i));
            }
            if (this.forward ^ model.forward) {
                throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.PROPAGATION_DIRECTION_MISMATCH, new Object[0]);
            }
            FieldODEStateInterpolator<T> lastInterpolator = this.steps.get(this.index);
            Object current = lastInterpolator.getCurrentState().getTime();
            Object previous = lastInterpolator.getPreviousState().getTime();
            RealFieldElement step = (RealFieldElement)current.subtract(previous);
            RealFieldElement gap = (RealFieldElement)model.getInitialTime().subtract(current);
            if (((RealFieldElement)((RealFieldElement)gap.abs()).subtract((Object)((RealFieldElement)((RealFieldElement)step.abs()).multiply(0.001)))).getReal() > 0.0) {
                throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.HOLE_BETWEEN_MODELS_TIME_RANGES, new Object[]{((RealFieldElement)gap.abs()).getReal()});
            }
        }
        for (FieldODEStateInterpolator<T> interpolator : model.steps) {
            this.steps.add(interpolator);
        }
        this.index = this.steps.size() - 1;
        this.finalTime = this.steps.get(this.index).getCurrentState().getTime();
    }

    private void checkDimensionsEquality(int d1, int d2) throws MathIllegalArgumentException {
        if (d1 != d2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{d2, d1});
        }
    }

    @Override
    public void init(FieldODEStateAndDerivative<T> initialState, T t) {
        this.initialTime = initialState.getTime();
        this.finalTime = t;
        this.forward = true;
        this.index = 0;
        this.steps.clear();
    }

    @Override
    public void handleStep(FieldODEStateInterpolator<T> interpolator, boolean isLast) throws MathIllegalStateException {
        if (this.steps.size() == 0) {
            this.initialTime = interpolator.getPreviousState().getTime();
            this.forward = interpolator.isForward();
        }
        this.steps.add(interpolator);
        if (isLast) {
            this.finalTime = interpolator.getCurrentState().getTime();
            this.index = this.steps.size() - 1;
        }
    }

    public T getInitialTime() {
        return this.initialTime;
    }

    public T getFinalTime() {
        return this.finalTime;
    }

    public FieldODEStateAndDerivative<T> getInterpolatedState(T time) {
        int iMin = 0;
        FieldODEStateInterpolator<T> sMin = this.steps.get(iMin);
        RealFieldElement tMin = (RealFieldElement)((RealFieldElement)sMin.getPreviousState().getTime().add(sMin.getCurrentState().getTime())).multiply(0.5);
        int iMax = this.steps.size() - 1;
        FieldODEStateInterpolator<T> sMax = this.steps.get(iMax);
        RealFieldElement tMax = (RealFieldElement)((RealFieldElement)sMax.getPreviousState().getTime().add(sMax.getCurrentState().getTime())).multiply(0.5);
        if (this.locatePoint(time, sMin) <= 0) {
            this.index = iMin;
            return sMin.getInterpolatedState(time);
        }
        if (this.locatePoint(time, sMax) >= 0) {
            this.index = iMax;
            return sMax.getInterpolatedState(time);
        }
        while (iMax - iMin > 5) {
            FieldODEStateInterpolator<T> si = this.steps.get(this.index);
            int location = this.locatePoint(time, si);
            if (location < 0) {
                iMax = this.index;
                tMax = (RealFieldElement)((RealFieldElement)si.getPreviousState().getTime().add(si.getCurrentState().getTime())).multiply(0.5);
            } else if (location > 0) {
                iMin = this.index;
                tMin = (RealFieldElement)((RealFieldElement)si.getPreviousState().getTime().add(si.getCurrentState().getTime())).multiply(0.5);
            } else {
                return si.getInterpolatedState(time);
            }
            int iMed = (iMin + iMax) / 2;
            FieldODEStateInterpolator<T> sMed = this.steps.get(iMed);
            RealFieldElement tMed = (RealFieldElement)((RealFieldElement)sMed.getPreviousState().getTime().add(sMed.getCurrentState().getTime())).multiply(0.5);
            if (((RealFieldElement)((RealFieldElement)((RealFieldElement)tMed.subtract((Object)tMin)).abs()).subtract(1.0E-6)).getReal() < 0.0 || ((RealFieldElement)((RealFieldElement)((RealFieldElement)tMax.subtract((Object)tMed)).abs()).subtract(1.0E-6)).getReal() < 0.0) {
                this.index = iMed;
            } else {
                RealFieldElement d12 = (RealFieldElement)tMax.subtract((Object)tMed);
                RealFieldElement d23 = (RealFieldElement)tMed.subtract((Object)tMin);
                RealFieldElement d13 = (RealFieldElement)tMax.subtract((Object)tMin);
                RealFieldElement dt1 = (RealFieldElement)time.subtract((Object)tMax);
                RealFieldElement dt2 = (RealFieldElement)time.subtract((Object)tMed);
                RealFieldElement dt3 = (RealFieldElement)time.subtract((Object)tMin);
                RealFieldElement iLagrange = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dt2.multiply((Object)dt3)).multiply((Object)d23)).multiply(iMax)).subtract((Object)((RealFieldElement)((RealFieldElement)((RealFieldElement)dt1.multiply((Object)dt3)).multiply((Object)d13)).multiply(iMed)))).add((Object)((RealFieldElement)((RealFieldElement)((RealFieldElement)dt1.multiply((Object)dt2)).multiply((Object)d12)).multiply(iMin)))).divide((Object)((RealFieldElement)((RealFieldElement)d12.multiply((Object)d23)).multiply((Object)d13)));
                this.index = (int)FastMath.rint((double)iLagrange.getReal());
            }
            int low = FastMath.max((int)(iMin + 1), (int)((9 * iMin + iMax) / 10));
            int high = FastMath.min((int)(iMax - 1), (int)((iMin + 9 * iMax) / 10));
            if (this.index < low) {
                this.index = low;
                continue;
            }
            if (this.index <= high) continue;
            this.index = high;
        }
        this.index = iMin;
        while (this.index <= iMax && this.locatePoint(time, this.steps.get(this.index)) > 0) {
            ++this.index;
        }
        return this.steps.get(this.index).getInterpolatedState(time);
    }

    private int locatePoint(T time, FieldODEStateInterpolator<T> interval) {
        if (this.forward) {
            if (((RealFieldElement)time.subtract(interval.getPreviousState().getTime())).getReal() < 0.0) {
                return -1;
            }
            if (((RealFieldElement)time.subtract(interval.getCurrentState().getTime())).getReal() > 0.0) {
                return 1;
            }
            return 0;
        }
        if (((RealFieldElement)time.subtract(interval.getPreviousState().getTime())).getReal() > 0.0) {
            return -1;
        }
        if (((RealFieldElement)time.subtract(interval.getCurrentState().getTime())).getReal() < 0.0) {
            return 1;
        }
        return 0;
    }
}

