/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.RealFieldElement;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.FieldAbsoluteDate;

public abstract class FieldAbstractDetector<D extends FieldEventDetector<T>, T extends RealFieldElement<T>>
implements FieldEventDetector<T> {
    public static final double DEFAULT_MAXCHECK = 600.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-6;
    public static final int DEFAULT_MAX_ITER = 100;
    private final T maxCheck;
    private final T threshold;
    private final int maxIter;
    private final FieldEventHandler<? super D, T> handler;
    private boolean forward;

    protected FieldAbstractDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super D, T> handler) {
        this.maxCheck = maxCheck;
        this.threshold = threshold;
        this.maxIter = maxIter;
        this.handler = handler;
        this.forward = true;
    }

    @Override
    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) throws OrekitException {
        this.forward = t.durationFrom(s0.getDate()).getReal() >= 0.0;
        this.getHandler().init(s0, t);
    }

    @Override
    public abstract T g(FieldSpacecraftState<T> var1) throws OrekitException;

    @Override
    public T getMaxCheckInterval() {
        return this.maxCheck;
    }

    @Override
    public int getMaxIterationCount() {
        return this.maxIter;
    }

    @Override
    public T getThreshold() {
        return this.threshold;
    }

    public D withMaxCheck(T newMaxCheck) {
        return this.create(newMaxCheck, this.getThreshold(), this.getMaxIterationCount(), this.getHandler());
    }

    public D withMaxIter(int newMaxIter) {
        return this.create(this.getMaxCheckInterval(), this.getThreshold(), newMaxIter, this.getHandler());
    }

    public D withThreshold(T newThreshold) {
        return this.create(this.getMaxCheckInterval(), newThreshold, this.getMaxIterationCount(), this.getHandler());
    }

    public D withHandler(FieldEventHandler<? super D, T> newHandler) {
        return this.create(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), newHandler);
    }

    public FieldEventHandler<? super D, T> getHandler() {
        return this.handler;
    }

    @Override
    public FieldEventHandler.Action eventOccurred(FieldSpacecraftState<T> s, boolean increasing) throws OrekitException {
        FieldEventHandler.Action whatNext = this.getHandler().eventOccurred(s, this, increasing);
        return whatNext;
    }

    @Override
    public FieldSpacecraftState<T> resetState(FieldSpacecraftState<T> oldState) throws OrekitException {
        FieldSpacecraftState<T> newState = this.getHandler().resetState(this, oldState);
        return newState;
    }

    protected abstract D create(T var1, T var2, int var3, FieldEventHandler<? super D, T> var4);

    public boolean isForward() {
        return this.forward;
    }
}

